/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.logging.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import rice.environment.logging.LogManager;
import rice.environment.logging.simple.SimpleLogManager;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.environment.time.simple.SimpleTimeSource;

public class FileLogManager
extends SimpleLogManager {
    String filePrefix;
    String fileSuffix;

    public FileLogManager(PrintStream stream, TimeSource timeSource, Parameters params) {
        this(stream, timeSource, params, "");
    }

    public FileLogManager(PrintStream stream, TimeSource timeSource, Parameters params, String prefix) {
        this(stream, timeSource, params, prefix, params.getString("fileLogManager_filePrefix"), params.getString("fileLogManager_fileSuffix"), null);
    }

    public FileLogManager(PrintStream stream, TimeSource timeSource, Parameters params, String prefix, String filePrefix, String fileSuffix, String dateFormat) {
        super(stream, timeSource, params, prefix, dateFormat);
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
    }

    public FileLogManager(Parameters params) {
        this(System.out, new SimpleTimeSource(), params);
    }

    public FileLogManager(PrintStream stream, Parameters params) {
        this(stream, new SimpleTimeSource(), params);
    }

    public FileLogManager(TimeSource timeSource, Parameters params) {
        this(System.out, timeSource, params);
    }

    public LogManager clone(String detail) {
        try {
            String fname = this.filePrefix + detail + this.fileSuffix;
            PrintStream newPS = new PrintStream(new FileOutputStream(fname, true));
            return new FileLogManager(newPS, this.time, this.params, "", this.filePrefix, this.fileSuffix, this.dateFormat);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

