/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class EncryptedKey
extends CMSObject {
    private ASN1OctetString key;

    public EncryptedKey(byte[] byArray) {
        this.setKey(byArray);
    }

    public EncryptedKey(ASN1OctetString aSN1OctetString) {
        this.key = aSN1OctetString;
    }

    public EncryptedKey(EncryptedKey encryptedKey) {
        this.key = encryptedKey.key;
    }

    public static EncryptedKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EncryptedKey.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static EncryptedKey getInstance(Object object) {
        if (object == null || object instanceof EncryptedKey) {
            return (EncryptedKey)object;
        }
        if (object instanceof ASN1OctetString) {
            return new EncryptedKey((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid EncryptedKey: " + object.getClass().getName());
    }

    public byte[] getKey() {
        return this.key.getOctets();
    }

    public DERObject getDERObject() {
        return this.key;
    }

    private void setKey(byte[] byArray) {
        this.key = new BERConstructedOctetString(byArray);
    }
}

