/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lesson4;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.lesson4.MyApp;

public class DistTutorial {
    Vector apps = new Vector();

    public DistTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        PastryNode node;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            node = ((PastryNodeFactory)factory).newNode(bootHandle);
            while (!node.isReady()) {
                Thread.sleep(100L);
            }
            System.out.println("Finished creating new node " + node);
            MyApp app = new MyApp(node);
            this.apps.add(app);
        }
        Thread.sleep(10000L);
        for (int i = 0; i < 10; ++i) {
            Iterator appIterator = this.apps.iterator();
            while (appIterator.hasNext()) {
                MyApp app = (MyApp)appIterator.next();
                Id randId = nidFactory.generateNodeId();
                app.routeMyMsg(randId);
                Thread.sleep(100L);
            }
        }
        Thread.sleep(1000L);
        Iterator appIterator = this.apps.iterator();
        while (appIterator.hasNext()) {
            MyApp app = (MyApp)appIterator.next();
            node = (PastryNode)app.getNode();
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = leafSet.get(i);
                app.routeMyMsgDirect(nh);
                Thread.sleep(100L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            DistTutorial dt = new DistTutorial(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson4.DistTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

