/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lesson3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.environment.Environment;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.lesson3.MyApp;

public class DistTutorial {
    public DistTutorial(int bindport, InetSocketAddress bootaddress, Environment env) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
        PastryNode node = ((PastryNodeFactory)factory).newNode(bootHandle);
        while (!node.isReady()) {
            Thread.sleep(100L);
        }
        System.out.println("Finished creating new node " + node);
        MyApp app = new MyApp(node);
        Thread.sleep(10000L);
        if (bootHandle != null) {
            for (int i = 0; i < 10; ++i) {
                Id randId = nidFactory.generateNodeId();
                app.routeMyMsg(randId);
                Thread.sleep(1000L);
            }
            Thread.sleep(10000L);
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = leafSet.get(i);
                app.routeMyMsgDirect(nh);
                Thread.sleep(1000L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            DistTutorial dt = new DistTutorial(bindport, bootaddress, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson3.DistTutorial localbindport bootIP bootPort");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001");
            throw e;
        }
    }
}

