/*
 * Decompiled with CFR 0.152.
 */
package rice.selector;

import rice.environment.time.TimeSource;
import rice.p2p.commonapi.CancellableTask;

public abstract class TimerTask
implements Comparable,
CancellableTask {
    protected long nextExecutionTime;
    protected boolean cancelled = false;
    protected int seq;
    protected int period = -1;
    protected boolean fixedRate = false;

    public boolean isCancelled() {
        return this.cancelled;
    }

    public abstract void run();

    public boolean execute(TimeSource ts) {
        if (this.cancelled) {
            return false;
        }
        this.run();
        if (this.cancelled) {
            return false;
        }
        if (this.period > 0) {
            if (this.fixedRate) {
                this.nextExecutionTime += (long)this.period;
                return true;
            }
            this.nextExecutionTime = ts.currentTimeMillis() + (long)this.period;
            return true;
        }
        return false;
    }

    public boolean cancel() {
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    public long scheduledExecutionTime() {
        return this.nextExecutionTime;
    }

    public int compareTo(Object arg0) {
        TimerTask tt = (TimerTask)arg0;
        if (tt == this) {
            return 0;
        }
        int diff = (int)(this.nextExecutionTime - tt.nextExecutionTime);
        if (diff == 0 && (diff = this.seq - tt.seq) == 0) {
            return System.identityHashCode(this) < System.identityHashCode(tt) ? 1 : -1;
        }
        return diff;
    }
}

