/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence.testing;

import java.util.Arrays;
import rice.environment.Environment;

public abstract class Test {
    protected Environment environment;
    protected static final String SUCCESS = "SUCCESS";
    protected static final String FAILURE = "FAILURE";
    protected static final int PAD_SIZE = 60;

    public Test(Environment env) {
        this.environment = env;
    }

    public abstract void start();

    protected void sectionStart(String name) {
        System.out.println(name);
    }

    protected void sectionEnd() {
        System.out.println();
    }

    protected void stepStart(String name) {
        System.out.print(this.pad("  " + name));
    }

    protected void stepDone(String status) {
        System.out.println("[" + status + "]");
        if (status.equals(FAILURE)) {
            System.exit(0);
        }
    }

    protected void stepDone(String status, String message) {
        System.out.println("[" + status + "]");
        System.out.println("    " + message);
        if (status.equals(FAILURE)) {
            System.exit(0);
        }
    }

    protected void stepException(Exception e) {
        System.out.println();
        System.out.println("Exception " + e + " occurred during testing.");
        e.printStackTrace();
        System.exit(0);
    }

    private String pad(String start) {
        if (start.length() >= 60) {
            return start.substring(0, 60);
        }
        int spaceLength = 60 - start.length();
        char[] spaces = new char[spaceLength];
        Arrays.fill(spaces, '.');
        return start.concat(new String(spaces));
    }
}

