/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.zip.GZIPOutputStream;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.util.XMLObjectOutputStream;
import rice.persistence.Cache;
import rice.persistence.Storage;

public class LRUCache
implements Cache {
    private int maximumSize;
    private Storage storage;
    private LinkedList order;
    protected Environment environment;

    public LRUCache(Storage storage, int maximumSize, Environment env) {
        this.environment = env;
        this.storage = storage;
        this.maximumSize = maximumSize;
        this.order = new LinkedList();
        Iterator i = storage.scan().getIterator();
        while (i.hasNext()) {
            this.order.addLast(i.next());
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObject(Id id, Continuation c) {
        if (!this.exists(id)) {
            c.receiveResult(null);
            return;
        }
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            this.order.remove(id);
            this.order.addFirst(id);
        }
        this.storage.getObject(id, c);
    }

    public Serializable getMetadata(Id id) {
        return this.storage.getMetadata(id);
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public int getSize() {
        return this.storage.getSize();
    }

    public long getTotalSize() {
        return this.storage.getTotalSize();
    }

    private int getSize(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLObjectOutputStream oos = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
            oos.writeObject(obj);
            ((ObjectOutputStream)oos).flush();
            return baos.toByteArray().length;
        }
        catch (IOException e) {
            Logger logger = this.environment.getLogManager().getLogger(LRUCache.class, null);
            if (logger.level <= 900) {
                logger.logException("", e);
            }
            return Integer.MAX_VALUE;
        }
    }

    public void setMetadata(Id id, Serializable metadata, Continuation command) {
        this.storage.setMetadata(id, metadata, command);
    }

    public void setMaximumSize(final int size, final Continuation c) {
        Continuation local = new Continuation(){

            public void receiveResult(Object o) {
                LRUCache.this.maximumSize = size;
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                c.receiveException(e);
            }
        };
        if (size < this.maximumSize) {
            this.resize(size, local);
        } else {
            local.receiveResult(new Boolean(true));
        }
    }

    public void rename(final Id oldId, final Id newId, Continuation c) {
        this.storage.rename(oldId, newId, new Continuation.StandardContinuation(c){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receiveResult(Object o) {
                LinkedList linkedList = LRUCache.this.order;
                synchronized (linkedList) {
                    LRUCache.this.order.remove(oldId);
                    LRUCache.this.order.addFirst(newId);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(final Id id, final Serializable metadata, final Serializable obj, final Continuation c) {
        int size = this.getSize(obj);
        if (this.exists(id)) {
            LinkedList linkedList = this.order;
            synchronized (linkedList) {
                this.order.remove(id);
                this.order.addFirst(id);
            }
            c.receiveResult(new Boolean(true));
            return;
        }
        if (size > this.maximumSize) {
            c.receiveResult(new Boolean(false));
            return;
        }
        Continuation store = new Continuation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receiveResult(Object o) {
                LinkedList linkedList = LRUCache.this.order;
                synchronized (linkedList) {
                    LRUCache.this.order.addFirst(id);
                }
                LRUCache.this.storage.store(id, metadata, obj, c);
            }

            public void receiveException(Exception e) {
                c.receiveException(e);
            }
        };
        long totalSize = this.storage.getTotalSize();
        if ((long)(this.maximumSize - size) < totalSize) {
            this.resize(this.maximumSize - size, store);
        } else {
            store.receiveResult(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncache(Id id, Continuation c) {
        LinkedList linkedList = this.order;
        synchronized (linkedList) {
            this.order.remove(id);
        }
        this.storage.unstore(id, c);
    }

    public boolean exists(Id id) {
        return this.storage.exists(id);
    }

    public synchronized IdSet scan(IdRange range) {
        return this.storage.scan(range);
    }

    public synchronized IdSet scan() {
        return this.storage.scan();
    }

    public SortedMap scanMetadata(IdRange range) {
        return this.storage.scanMetadata(range);
    }

    public SortedMap scanMetadata() {
        return this.storage.scanMetadata();
    }

    public SortedMap scanMetadataValuesHead(Object value) {
        return this.storage.scanMetadataValuesHead(value);
    }

    public SortedMap scanMetadataValuesNull() {
        return this.storage.scanMetadataValuesNull();
    }

    private void resize(final int size, Continuation c) {
        Continuation.StandardContinuation remove = new Continuation.StandardContinuation(c){
            private boolean waitingForSize;
            {
                super(x0);
                this.waitingForSize = true;
            }

            public void receiveResult(Object o) {
                if (LRUCache.this.storage.getTotalSize() > (long)size) {
                    LRUCache.this.uncache((Id)LRUCache.this.order.getLast(), this);
                } else {
                    this.parent.receiveResult(new Boolean(true));
                }
            }
        };
        remove.receiveResult(Boolean.TRUE);
    }

    public void flush(Continuation c) {
        this.storage.flush(new Continuation.StandardContinuation(c){

            public void receiveResult(Object o) {
                LRUCache.this.order.clear();
                this.parent.receiveResult(Boolean.TRUE);
            }
        });
    }
}

