/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.TestRecord;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.Ping;

public class SinglePingTest {
    private DirectPastryNodeFactory factory;
    private NetworkSimulator simulator;
    private TestRecord testRecord;
    private Vector pastryNodes;
    private Vector pingClients;
    private Environment environment;

    public SinglePingTest(TestRecord tr, Environment env) {
        this.environment = env;
        this.simulator = new EuclideanNetwork(env);
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(this.environment), this.simulator, env);
        this.simulator.setTestRecord(tr);
        this.testRecord = tr;
        this.pastryNodes = new Vector();
        this.pingClients = new Vector();
    }

    private NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastryNode makePastryNode() {
        PastryNode pn = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pn);
        Ping pc = new Ping(pn);
        this.pingClients.addElement(pc);
        long start = System.currentTimeMillis();
        PastryNode pastryNode = pn;
        synchronized (pastryNode) {
            while (!pn.isReady()) {
                try {
                    pn.wait(300L);
                }
                catch (InterruptedException ie) {}
            }
        }
        long now = System.currentTimeMillis();
        if (now - start > 2000L) {
            System.out.println("Took " + (now - start) + " to create node " + pn);
        }
        return pn;
    }

    public void sendPings(int k) {
        int n = this.pingClients.size();
        for (int i = 0; i < k; ++i) {
            int from = this.environment.getRandomSource().nextInt(n);
            int to = this.environment.getRandomSource().nextInt(n);
            Ping pc = (Ping)this.pingClients.get(from);
            PastryNode pn = (PastryNode)this.pastryNodes.get(to);
            pc.sendPing(pn.getNodeId());
            while (this.simulate()) {
            }
        }
    }

    public boolean simulate() {
        return false;
    }

    public void checkRoutingTable() {
        int i;
        Date prev = new Date();
        for (i = 0; i < this.testRecord.getNodeNumber(); ++i) {
            PastryNode pn = this.makePastryNode();
            while (this.simulate()) {
            }
            System.out.println(pn.getLeafSet());
            if (i == 0 || i % 1000 != 0) continue;
            System.out.println(i + " nodes constructed");
        }
        System.out.println(i + " nodes constructed");
        Date curr = new Date();
        long msec = curr.getTime() - prev.getTime();
        System.out.println("time used " + msec / 60000L + ":" + msec % 60000L / 1000L + ":" + msec % 60000L % 1000L);
    }

    public void test() {
        int i;
        Date prev = new Date();
        System.out.println("-------------------------");
        for (i = 0; i < this.testRecord.getNodeNumber(); ++i) {
            PastryNode pn = this.makePastryNode();
            while (this.simulate()) {
            }
            if (i == 0 || i % 500 != 0) continue;
            System.out.println(i + " nodes constructed");
        }
        System.out.println(i + " nodes constructed");
        Date curr = new Date();
        long msec = curr.getTime() - prev.getTime();
        System.out.println("time used " + msec / 60000L + ":" + msec % 60000L / 1000L + ":" + msec % 60000L % 1000L);
        prev = curr;
        this.sendPings(this.testRecord.getTestNumber());
        System.out.println(this.testRecord.getTestNumber() + " lookups done");
        curr = new Date();
        msec = curr.getTime() - prev.getTime();
        System.out.println("time used " + msec / 60000L + ":" + msec % 60000L / 1000L + ":" + msec % 60000L % 1000L);
        this.testRecord.doneTest();
    }
}

