/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.CommonAPIAppl;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.SendOptions;
import rice.pastry.testing.PastryRegrTest;
import rice.pastry.testing.RTMessage;

public class RegrTestApp
extends CommonAPIAppl {
    private PastryRegrTest prg;
    private static int addr = RTAddress.getCode();

    public RegrTestApp(PastryNode pn, PastryRegrTest prg) {
        super(pn);
        this.prg = prg;
    }

    public int getAddress() {
        return addr;
    }

    public PastryNode getPastryNode() {
        return this.thePastryNode;
    }

    public void sendMsg(Id nid) {
        this.routeMsg(nid, new RTMessage(addr, this.getNodeHandle(), nid), new SendOptions());
    }

    public void sendTrace(Id nid) {
        this.routeMsg(nid, new RTMessage(addr, this.getNodeHandle(), nid), new SendOptions());
    }

    public void deliver(Id key, Message msg) {
        RTMessage rmsg = (RTMessage)msg;
        Id localId = this.getNodeId();
        if (localId != key) {
            int inBetween;
            if (localId.compareTo(key) < 0) {
                int i2;
                int i1 = this.prg.pastryNodesSortedReady.subMap(localId, key).size();
                inBetween = i1 < (i2 = this.prg.pastryNodesSortedReady.tailMap(key).size() + this.prg.pastryNodesSortedReady.headMap(localId).size()) ? i1 : i2;
            } else {
                int i2;
                int i1 = this.prg.pastryNodesSortedReady.subMap(key, localId).size();
                int n = inBetween = i1 < (i2 = this.prg.pastryNodesSortedReady.tailMap(localId).size() + this.prg.pastryNodesSortedReady.headMap(key).size()) ? i1 : i2;
            }
            if (inBetween > 1) {
                System.out.println("messageForAppl failure, inBetween=" + inBetween);
                System.out.print(msg);
                System.out.println(" received at " + this.getNodeId());
                System.out.println(this.getLeafSet());
            }
        }
    }

    public void forward(RouteMessage rm) {
        Message msg = rm.unwrap();
        Id key = rm.getTarget();
        Id nextHop = rm.getNextHop().getNodeId();
        Id localId = this.getNodeId();
        Id.Distance dist = localId.distance(key);
        byte base = this.getRoutingTable().baseBitLength();
        if (this.prg.lastMsg == msg) {
            int lastIndex;
            int localIndex = localId.indexOfMSDD(key, base);
            if (localIndex > (lastIndex = this.prg.lastNode.indexOfMSDD(key, base)) && nextHop != localId || localIndex == lastIndex && dist.compareTo(this.prg.lastDist) > 0) {
                System.out.println("at... " + this.getNodeId() + " enrouteMessage failure with " + msg + " lastNode=" + this.prg.lastNode + " lastDist=" + this.prg.lastDist + " dist=" + dist + " nextHop=" + nextHop + " loci=" + localIndex + " lasti=" + lastIndex);
            }
            this.prg.lastDist = dist;
        }
        this.prg.lastMsg = msg;
        this.prg.lastDist = dist;
        this.prg.lastNode = localId;
    }

    public void update(NodeHandle nh, boolean wasAdded) {
        int lsSize;
        int i2;
        int i1;
        int inBetween;
        Id localId;
        Id nid = nh.getNodeId();
        if (!this.prg.pastryNodesSorted.containsKey(nid) && nh.isAlive()) {
            System.out.println("at... " + this.getNodeId() + "leafSetChange failure 1 with " + nid);
        }
        if ((localId = this.thePastryNode.getNodeId()) == nid) {
            System.out.println("at... " + this.getNodeId() + "leafSetChange failure 2 with " + nid);
        }
        if ((inBetween = localId.compareTo(nid) < 0 ? ((i1 = this.prg.pastryNodesSorted.subMap(localId, nid).size()) < (i2 = this.prg.pastryNodesSorted.tailMap(nid).size() + this.prg.pastryNodesSorted.headMap(localId).size()) ? i1 : i2) : ((i1 = this.prg.pastryNodesSorted.subMap(nid, localId).size()) < (i2 = this.prg.pastryNodesSorted.tailMap(localId).size() + this.prg.pastryNodesSorted.headMap(nid).size()) ? i1 : i2)) > (lsSize = this.getLeafSet().maxSize() / 2) && wasAdded && !this.prg.pastryNodesLastAdded.contains(this.thePastryNode) && !this.prg.inConcJoin || inBetween <= lsSize && !wasAdded && !this.getLeafSet().member(nh) && this.prg.pastryNodesSorted.containsKey(nh.getNodeId())) {
            System.out.println("at... " + this.getNodeId() + "leafSetChange failure 3 with " + nid + " wasAdded=" + wasAdded + " inBetween=" + inBetween);
            System.out.println(this.getLeafSet());
        }
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
        Id nid = nh.getNodeId();
        if (!this.prg.pastryNodesSorted.containsKey(nid) && (nh.isAlive() || wasAdded)) {
            System.out.println("at... " + this.getNodeId() + "routeSetChange failure 1 with " + nid + " wasAdded=" + wasAdded);
        }
    }

    public void notifyReady() {
    }

    private static class RTAddress {
        private static int myCode = -1843800321;

        private RTAddress() {
        }

        public static int getCode() {
            return myCode;
        }
    }
}

