/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.direct.TestRecord;

public class PingTestRecord
extends TestRecord {
    private int nIndex;
    private int[] nHops;
    private double[] fProb;
    private double fHops;
    private double fDistance = 0.0;

    public PingTestRecord(int n, int k, int baseBitLength) {
        super(n, k);
        this.nIndex = (int)Math.ceil(Math.log(n) / Math.log(Math.pow(2.0, baseBitLength)));
        this.nIndex *= 3;
        this.nHops = new int[this.nIndex * 2];
        this.fProb = new double[this.nIndex * 2];
    }

    public double getAveHops() {
        return this.fHops;
    }

    public double getAveDistance() {
        return this.fDistance;
    }

    public double[] getProbability() {
        return this.fProb;
    }

    public void doneTest() {
        int i;
        long sum = 0L;
        for (i = 0; i < this.nIndex; ++i) {
            sum += (long)(this.nHops[i] * i);
        }
        this.fHops = (double)sum / (double)this.nTests;
        this.fDistance /= (double)this.nTests;
        for (i = 0; i < this.nIndex; ++i) {
            this.fProb[i] = (double)(i * this.nHops[i]) / (double)sum;
        }
    }

    public void addHops(int index) {
        int n = index;
        this.nHops[n] = this.nHops[n] + 1;
    }

    public void addDistance(double rDistance) {
        this.fDistance += rDistance;
    }
}

