/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNodeFactory;

public class PartitionChecker {
    protected final int MAX_THREADS = 100;
    int numThreads = 0;
    HashSet unmatchedBootstraps;
    HashSet bootstraps;
    final PrintStream ps = new PrintStream(new FileOutputStream("response.txt"));
    ArrayList rings;
    Environment environment;
    HashSet dead = new HashSet();

    public PartitionChecker(String ringIdString) throws Exception {
        this.environment = new Environment();
        this.buildBootstrapSetFromCert(ringIdString);
        this.rings = new ArrayList();
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(null, 1, this.environment);
        while (this.unmatchedBootstraps.size() > 0) {
            this.rings.add(this.buildRing(factory, (InetSocketAddress)this.unmatchedBootstraps.iterator().next()));
        }
        Collections.sort(this.rings);
        Iterator i = this.rings.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    protected void buildBootstrapSetFromCert(String ringIdString) throws Exception {
        this.unmatchedBootstraps = new HashSet();
        this.bootstraps = new HashSet();
        BufferedReader in = new BufferedReader(new FileReader(ringIdString));
        while (in.ready()) {
            String line = in.readLine();
            String[] parts = line.split(":");
            int port = 10003;
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
            }
            InetSocketAddress addr = new InetSocketAddress(parts[0], port);
            this.unmatchedBootstraps.add(addr);
            this.bootstraps.add(addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ring buildRing(final DistPastryNodeFactory factory, InetSocketAddress bootstrap) throws Exception {
        this.unmatchedBootstraps.remove(bootstrap);
        this.numThreads = 0;
        final Ring ring = new Ring(bootstrap);
        final HashSet<NodeHandle> unseen = new HashSet<NodeHandle>();
        unseen.add(factory.getNodeHandle(bootstrap, 20000));
        HashSet<NodeHandle> hashSet = unseen;
        synchronized (hashSet) {
            while (true) {
                if (this.numThreads >= 100) {
                    unseen.wait();
                }
                if (unseen.size() > 0) {
                    ++this.numThreads;
                    final SocketNodeHandle handle = (SocketNodeHandle)unseen.iterator().next();
                    if (handle == null) break;
                    unseen.remove(handle);
                    ring.addNode(handle);
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            HashSet hashSet;
                            try {
                                try {
                                    LeafSet ls = factory.getLeafSet(handle);
                                    PartitionChecker.this.ps.println(handle.getEpochAddress().getAddress().getAddress().getHostAddress() + ":" + handle.getEpochAddress().getAddress().getPort());
                                    NodeSet ns = ls.neighborSet(Integer.MAX_VALUE);
                                    if (!ns.get(0).equals(handle)) {
                                        ring.addFailure(handle, new Exception("Node is now " + ns.get(0)));
                                    }
                                    HashSet hashSet2 = unseen;
                                    synchronized (hashSet2) {
                                        for (int i = 1; i < ns.size(); ++i) {
                                            if (ring.contains(ns.get(i)) || PartitionChecker.this.dead.contains(ns.get(i))) continue;
                                            unseen.add(ns.get(i));
                                        }
                                    }
                                }
                                catch (ConnectException e) {
                                    ring.addFailure(handle, e);
                                    PartitionChecker.this.dead.add(handle);
                                    Object var7_9 = null;
                                    HashSet hashSet2 = unseen;
                                    synchronized (hashSet2) {
                                        --PartitionChecker.this.numThreads;
                                        unseen.notifyAll();
                                        return;
                                    }
                                }
                                catch (SocketTimeoutException e) {
                                    ring.addFailure(handle, e);
                                    PartitionChecker.this.dead.add(handle);
                                    Object var7_10 = null;
                                    HashSet hashSet4 = unseen;
                                    synchronized (hashSet4) {
                                        --PartitionChecker.this.numThreads;
                                        unseen.notifyAll();
                                        return;
                                    }
                                }
                                catch (IOException iOException) {
                                    Object var7_11 = null;
                                    HashSet hashSet5 = unseen;
                                    synchronized (hashSet5) {
                                        --PartitionChecker.this.numThreads;
                                        unseen.notifyAll();
                                        return;
                                    }
                                }
                                Object var7_8 = null;
                                hashSet = unseen;
                            }
                            catch (Throwable throwable) {
                                Object var7_12 = null;
                                HashSet hashSet6 = unseen;
                                synchronized (hashSet6) {
                                    --PartitionChecker.this.numThreads;
                                    unseen.notifyAll();
                                    throw throwable;
                                }
                            }
                            synchronized (hashSet) {
                                --PartitionChecker.this.numThreads;
                                unseen.notifyAll();
                                return;
                            }
                        }
                    };
                    t.start();
                    continue;
                }
                if (this.numThreads <= 0) break;
                unseen.wait();
            }
        }
        System.out.println("buildRing() complete:" + ring);
        return ring;
    }

    public static void main(String[] args) throws Exception {
        new PartitionChecker(args[0]);
        System.exit(0);
    }

    class Ring
    implements Comparable {
        HashSet myBootstraps;
        HashSet nodes;
        String name;

        public Ring(InetSocketAddress bootAddr) {
            this.name = bootAddr.toString();
            this.myBootstraps = new HashSet();
            this.myBootstraps.add(bootAddr);
            this.nodes = new HashSet();
        }

        public String getName() {
            return this.name;
        }

        public boolean contains(NodeHandle handle) {
            return this.nodes.contains(handle);
        }

        public void addFailure(SocketNodeHandle handle, Exception e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addNode(SocketNodeHandle snh) {
            InetSocketAddress newAddr = snh.getAddress();
            HashSet hashSet = PartitionChecker.this.unmatchedBootstraps;
            synchronized (hashSet) {
                if (PartitionChecker.this.unmatchedBootstraps.contains(newAddr)) {
                    PartitionChecker.this.unmatchedBootstraps.remove(newAddr);
                }
            }
            if (PartitionChecker.this.bootstraps.contains(newAddr)) {
                this.myBootstraps.add(newAddr);
            }
            this.nodes.add(snh);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Iterator i;
            String s = this.nodes.size() + ":" + this.myBootstraps.size() + ": boots:";
            HashSet hashSet = this.myBootstraps;
            synchronized (hashSet) {
                i = this.myBootstraps.iterator();
                s = s + i.next();
                while (i.hasNext()) {
                    s = s + "," + i.next();
                }
            }
            s = s + " non-boots:";
            hashSet = this.nodes;
            synchronized (hashSet) {
                i = this.nodes.iterator();
                while (i.hasNext()) {
                    Object nxt = i.next();
                    if (PartitionChecker.this.bootstraps.contains(nxt)) continue;
                    s = s + "," + nxt;
                }
            }
            return s;
        }

        public int compareTo(Object arg0) {
            Ring that = (Ring)arg0;
            return this.size() - that.size();
        }

        public int size() {
            return this.nodes.size();
        }
    }
}

