/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.IPNodeIdFactory;
import rice.pastry.testing.HelloWorldApp;

public class DistHelloWorld {
    private PastryNodeFactory factory;
    private Vector pastryNodes;
    private Vector helloClients;
    public Environment environment;
    private static int port = 5009;
    private static String bshost = null;
    private static int bsport = 5009;
    private static int numnodes = 1;
    private static int nummsgs = 2;
    public static int protocol = DistPastryNodeFactory.PROTOCOL_DEFAULT;

    public DistHelloWorld(Environment env) throws IOException {
        this.environment = env;
        this.factory = DistPastryNodeFactory.getFactory(new IPNodeIdFactory(InetAddress.getLocalHost(), port, env), protocol, port, env);
        this.pastryNodes = new Vector();
        this.helloClients = new Vector();
    }

    protected NodeHandle getBootstrap(boolean firstNode) {
        InetSocketAddress addr = null;
        if (firstNode && bshost != null) {
            addr = new InetSocketAddress(bshost, bsport);
        } else {
            try {
                addr = new InetSocketAddress(InetAddress.getLocalHost().getHostName(), bsport);
            }
            catch (UnknownHostException e) {
                System.out.println(e);
            }
        }
        NodeHandle bshandle = ((DistPastryNodeFactory)this.factory).getNodeHandle(addr);
        return bshandle;
    }

    public PastryNode makePastryNode(boolean firstNode) {
        NodeHandle bootstrap = this.getBootstrap(firstNode);
        PastryNode pn = this.factory.newNode(bootstrap);
        this.pastryNodes.addElement(pn);
        HelloWorldApp app = new HelloWorldApp(pn);
        this.helloClients.addElement(app);
        System.out.println("created " + pn);
        return pn;
    }

    private static void doIinitstuff(String[] args, Environment env) {
        int i;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-help")) continue;
            System.out.println("Usage: DistHelloWorld [-msgs m] [-nodes n] [-port p] [-bootstrap bshost[:bsport]]");
            System.out.println("                     [-protocol (rmi|wire)] [-verbose|-silent|-verbosity v] [-help]");
            System.out.println("");
            System.out.println("  Ports p and bsport refer to RMI registry  or Socket port numbers (default = 5009).");
            System.out.println("  Without -bootstrap bshost[:bsport], only localhost:p is used for bootstrap.");
            System.out.println("  Default verbosity is 8, -verbose is 1, and -silent is 10 (error msgs only).");
            System.exit(1);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-msgs") || i + 1 >= args.length) continue;
            nummsgs = Integer.parseInt(args[i + 1]);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-verbosity") || i + 1 >= args.length) continue;
            int num = Integer.parseInt(args[i + 1]);
            env.getParameters().setInt("loglevel", num * 100);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-silent") || i + 1 >= args.length) continue;
            env.getParameters().setInt("loglevel", 1000);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-verbose") || i + 1 >= args.length) continue;
            env.getParameters().setInt("loglevel", Integer.MIN_VALUE);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port") || i + 1 >= args.length) continue;
            int p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            port = p;
            bsport = p;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-bootstrap") || i + 1 >= args.length) continue;
            String str = args[i + 1];
            int index = str.indexOf(58);
            if (index == -1) {
                bshost = str;
                bsport = port;
                break;
            }
            bshost = str.substring(0, index);
            bsport = Integer.parseInt(str.substring(index + 1));
            if (bsport > 0) break;
            bsport = port;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-nodes") || i + 1 >= args.length) continue;
            int n = Integer.parseInt(args[i + 1]);
            if (n <= 0) break;
            numnodes = n;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-protocol") || i + 1 >= args.length) continue;
            String s = args[i + 1];
            if (s.equalsIgnoreCase("socket")) {
                protocol = DistPastryNodeFactory.PROTOCOL_SOCKET;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + s);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int i;
        PastryNode pn;
        Environment env = new Environment();
        env.getParameters().setInt("loglevel", 800);
        DistHelloWorld.doIinitstuff(args, env);
        DistHelloWorld driver = new DistHelloWorld(env);
        PastryNode pastryNode = pn = driver.makePastryNode(true);
        synchronized (pastryNode) {
            while (!pn.isReady()) {
                try {
                    pn.wait();
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
        }
        for (i = 1; i < numnodes; ++i) {
            PastryNode e = pn = driver.makePastryNode(false);
            synchronized (e) {
                while (!pn.isReady()) {
                    try {
                        pn.wait();
                    }
                    catch (InterruptedException e2) {
                        System.out.println(e2);
                    }
                }
                continue;
            }
        }
        System.out.println(numnodes + " nodes constructed");
        for (i = 0; i < nummsgs; ++i) {
            for (int client = 0; client < driver.helloClients.size(); ++client) {
                HelloWorldApp app = (HelloWorldApp)driver.helloClients.get(client);
                app.sendRndMsg(driver.environment.getRandomSource());
            }
        }
    }
}

