/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RouterAddress;

public class StandardRouter
extends PastryAppl {
    public StandardRouter(PastryNode thePastryNode) {
        super(thePastryNode, RouterAddress.getCode());
    }

    public void receiveMessage(Message msg) {
        if (!(msg instanceof RouteMessage)) {
            throw new Error("message " + msg + " bounced at StandardRouter");
        }
        this.route((RouteMessage)msg);
    }

    private void route(RouteMessage rm) {
        if (!rm.routeMessage(this.thePastryNode.getLocalHandle())) {
            this.receiveRouteMessage(rm);
        }
    }

    private void receiveRouteMessage(RouteMessage msg) {
        Id target = msg.getTarget();
        if (target == null) {
            target = this.thePastryNode.getNodeId();
        }
        int cwSize = this.thePastryNode.getLeafSet().cwSize();
        int ccwSize = this.thePastryNode.getLeafSet().ccwSize();
        int lsPos = this.thePastryNode.getLeafSet().mostSimilar(target);
        if (lsPos == 0) {
            msg.nextHop = this.thePastryNode.getLocalHandle();
        } else if (lsPos > 0 && (lsPos < cwSize || !this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target))) {
            NodeHandle handle = this.thePastryNode.getLeafSet().get(lsPos);
            if (!handle.isAlive()) {
                this.thePastryNode.getLeafSet().remove(handle);
                this.receiveRouteMessage(msg);
                return;
            }
            msg.nextHop = handle;
            msg.getOptions().setRerouteIfSuspected(false);
        } else {
            RouteSet rs = this.thePastryNode.getRoutingTable().getBestEntry(target);
            NodeHandle handle = null;
            if (rs == null || (handle = rs.closestNode(1)) == null) {
                handle = this.thePastryNode.getRoutingTable().bestAlternateRoute(1, target);
                if (handle == null) {
                    handle = this.thePastryNode.getLeafSet().get(lsPos);
                    if (!handle.isAlive()) {
                        this.thePastryNode.getLeafSet().remove(handle);
                        this.receiveRouteMessage(msg);
                        return;
                    }
                    msg.getOptions().setRerouteIfSuspected(false);
                } else {
                    Id.Distance altDist = handle.getNodeId().distance(target);
                    Id.Distance lsDist = this.thePastryNode.getLeafSet().get(lsPos).getNodeId().distance(target);
                    if (lsDist.compareTo(altDist) < 0) {
                        handle = this.thePastryNode.getLeafSet().get(lsPos);
                        if (!handle.isAlive()) {
                            this.thePastryNode.getLeafSet().remove(handle);
                            this.receiveRouteMessage(msg);
                            return;
                        }
                        msg.getOptions().setRerouteIfSuspected(false);
                    }
                }
            } else {
                this.checkForRouteTableHole(msg, handle);
            }
            msg.nextHop = handle;
        }
        msg.setPrevNode(this.thePastryNode.getLocalHandle());
        this.thePastryNode.getLocalHandle().receiveMessage(msg);
    }

    private void checkForRouteTableHole(RouteMessage msg, NodeHandle handle) {
        Id key;
        if (msg.getPrevNode() == null) {
            return;
        }
        Id prevId = msg.getPrevNode().getNodeId();
        int diffDigit = prevId.indexOfMSDD(key = msg.getTarget(), this.thePastryNode.getRoutingTable().baseBitLength());
        if (diffDigit == this.thePastryNode.getNodeId().indexOfMSDD(key, this.thePastryNode.getRoutingTable().baseBitLength())) {
            RouteSet[] row = this.thePastryNode.getRoutingTable().getRow(diffDigit);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.thePastryNode.getLocalHandle(), row);
            NodeHandle prevNode = msg.getPrevNode();
            if (prevNode.isAlive()) {
                prevNode.receiveMessage(brr);
            }
        }
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }
}

