/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.HashSet;
import java.util.WeakHashMap;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.util.TimerWeakHashMap;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.ReadyStrategy;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.InitiatePingNeighbor;
import rice.selector.TimerTask;

public class PeriodicLeafSetProtocol
extends PastryAppl
implements ReadyStrategy,
NodeSetListener {
    protected NodeHandle localHandle;
    protected PastryNode localNode;
    protected LeafSet leafSet;
    protected RoutingTable routeTable;
    protected WeakHashMap lastTimeReceivedBLS;
    protected WeakHashMap lastTimeSentBLS;
    public final int PING_NEIGHBOR_PERIOD;
    public final int LEASE_PERIOD;
    public final int CHECK_LIVENESS_PERIOD;
    public final int BLS_THROTTLE = 5000;
    ScheduledMessage pingNeighborMessage;
    RandomSource random;
    boolean hasSetStrategy = false;
    NodeHandle lastLeft;
    NodeHandle lastRight;
    boolean ready = false;
    HashSet deadLeases = new HashSet();
    WeakHashMap lastTimeRenewedLease;

    public PeriodicLeafSetProtocol(PastryNode ln, NodeHandle local, LeafSet ls, RoutingTable rt) {
        super(ln, null, LeafSetProtocolAddress.getCode(), new PLSPMessageDeserializer(ln));
        this.localNode = ln;
        Parameters params = ln.getEnvironment().getParameters();
        this.random = params.contains("pastry_periodic_leafset_protocol_use_own_random") && params.getBoolean("pastry_periodic_leafset_protocol_use_own_random") ? (params.contains("pastry_periodic_leafset_protocol_random_seed") && !params.getString("pastry_periodic_leafset_protocol_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_periodic_leafset_protocol_random_seed"), ln.getEnvironment().getLogManager(), "socket") : new SimpleRandomSource(ln.getEnvironment().getLogManager(), "periodic_leaf_set")) : ln.getEnvironment().getRandomSource();
        this.localHandle = local;
        this.leafSet = ls;
        this.routeTable = rt;
        this.lastTimeReceivedBLS = new TimerWeakHashMap(ln.getEnvironment().getSelectorManager().getTimer(), 300000);
        this.lastTimeSentBLS = new TimerWeakHashMap(ln.getEnvironment().getSelectorManager().getTimer(), 300000);
        Parameters p = ln.getEnvironment().getParameters();
        this.PING_NEIGHBOR_PERIOD = p.getInt("pastry_protocol_periodicLeafSet_ping_neighbor_period");
        this.LEASE_PERIOD = p.getInt("pastry_protocol_periodicLeafSet_lease_period");
        this.CHECK_LIVENESS_PERIOD = this.PING_NEIGHBOR_PERIOD + p.getInt("pastry_protocol_periodicLeafSet_checkLiveness_neighbor_gracePeriod");
        this.lastTimeRenewedLease = new TimerWeakHashMap(ln.getEnvironment().getSelectorManager().getTimer(), this.LEASE_PERIOD * 2);
        this.pingNeighborMessage = this.localNode.scheduleMsgAtFixedRate(new InitiatePingNeighbor(), this.PING_NEIGHBOR_PERIOD, this.PING_NEIGHBOR_PERIOD);
    }

    public boolean isReady() {
        boolean shouldBeReady = this.shouldBeReady();
        if (shouldBeReady != this.ready) {
            this.thePastryNode.setReady(shouldBeReady);
        }
        return shouldBeReady;
    }

    public void setReady(boolean r) {
        if (this.ready != r) {
            this.ready = r;
            this.thePastryNode.notifyReadyObservers();
        }
    }

    private void updateRecBLS(NodeHandle from, long time) {
        Long oldTime = (Long)this.lastTimeReceivedBLS.get(from);
        if (oldTime == null || oldTime < time) {
            this.lastTimeReceivedBLS.put(from, new Long(time));
            if (this.logger.level <= 500) {
                this.logger.log("PLSP.updateRecBLS(" + from + "," + time + ")");
            }
            if (this.hasSetStrategy) {
                this.isReady();
            }
        }
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof BroadcastLeafSet) {
            BroadcastLeafSet bls = (BroadcastLeafSet)msg;
            if (bls.type() == 1) {
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, false, null);
                this.broadcastAll();
            } else {
                int i;
                NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set.size(); ++i) {
                    if (!bls.leafSet().test(set.get(i))) continue;
                    set.get(i).checkLiveness();
                }
                set = bls.leafSet().neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set.size(); ++i) {
                    if (set.get(i).isAlive()) continue;
                    set.get(i).checkLiveness();
                }
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, false, null);
            }
            if (bls.leafSet().get(1) == this.localHandle || bls.leafSet().get(-1) == this.localHandle) {
                this.updateRecBLS(bls.from(), bls.getTimeStamp());
            }
        } else if (msg instanceof RequestLeafSet) {
            RequestLeafSet rls = (RequestLeafSet)msg;
            this.thePastryNode.send(rls.returnHandle(), new BroadcastLeafSet(this.localHandle, this.leafSet, 0, rls.getTimeStamp()));
            if (rls.getTimeStamp() > 0L) {
                this.lastTimeRenewedLease.put(rls.returnHandle(), new Long(this.localNode.getEnvironment().getTimeSource().currentTimeMillis()));
            }
        } else if (msg instanceof InitiateLeafSetMaintenance) {
            NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
            if (set.size() > 1) {
                NodeHandle handle = set.get(this.random.nextInt(set.size() - 1) + 1);
                this.thePastryNode.send(handle, new RequestLeafSet(this.localHandle, this.localNode.getEnvironment().getTimeSource().currentTimeMillis()));
                this.thePastryNode.send(handle, new BroadcastLeafSet(this.localHandle, this.leafSet, 0, 0L));
                NodeHandle check = set.get(this.random.nextInt(set.size() - 1) + 1);
                check.checkLiveness();
            }
        } else if (msg instanceof InitiatePingNeighbor) {
            NodeHandle left = this.leafSet.get(-1);
            NodeHandle right = this.leafSet.get(1);
            if (left != null) {
                this.sendBLS(left);
            }
            if (right != null) {
                this.sendBLS(right);
            }
        }
    }

    protected void broadcastAll() {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, 2, 0L);
        NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
        for (int i = 1; i < set.size(); ++i) {
            this.thePastryNode.send(set.get(i), bls);
        }
    }

    public void start() {
        if (!this.hasSetStrategy) {
            if (this.logger.level <= 800) {
                this.logger.log("PLSP.start(): Setting self as ReadyStrategy");
            }
            this.ready = true;
            this.localNode.setReadyStrategy(this);
            this.hasSetStrategy = true;
            this.localNode.addLeafSetListener(this);
        }
    }

    public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
        NodeHandle newRight;
        NodeHandle newLeft = this.leafSet.get(-1);
        if (!(added || handle != this.lastLeft && handle != this.lastRight)) {
            long curTime = this.localNode.getEnvironment().getTimeSource().currentTimeMillis();
            long leaseOffset = curTime - (long)this.LEASE_PERIOD;
            Long time = (Long)this.lastTimeRenewedLease.get(handle);
            if (time != null && time >= leaseOffset) {
                TimerTask deadLease = new TimerTask(){

                    public void run() {
                        PeriodicLeafSetProtocol.this.deadLeases.remove(this);
                        PeriodicLeafSetProtocol.this.isReady();
                    }
                };
                this.deadLeases.add(deadLease);
                this.localNode.getEnvironment().getSelectorManager().getTimer().schedule(deadLease, time - leaseOffset);
                this.isReady();
            }
        }
        if (this.lastLeft != newLeft) {
            this.lastLeft = newLeft;
            this.sendBLS(this.lastLeft);
        }
        if (this.lastRight != (newRight = this.leafSet.get(1))) {
            this.lastRight = newRight;
            this.sendBLS(this.lastRight);
        }
    }

    public boolean shouldBeReady() {
        Long time;
        long curTime = this.localNode.getEnvironment().getTimeSource().currentTimeMillis();
        long leaseOffset = curTime - (long)this.LEASE_PERIOD;
        NodeHandle left = this.leafSet.get(-1);
        NodeHandle right = this.leafSet.get(1);
        if (right != null && ((time = (Long)this.lastTimeReceivedBLS.get(right)) == null || time < leaseOffset)) {
            this.sendBLS(right);
            return false;
        }
        if (left != null && ((time = (Long)this.lastTimeReceivedBLS.get(left)) == null || time < leaseOffset)) {
            this.sendBLS(left);
            return false;
        }
        return this.deadLeases.size() <= 0;
    }

    private boolean sendBLS(NodeHandle sendTo) {
        Long time = (Long)this.lastTimeSentBLS.get(sendTo);
        if (time == null || time < this.localNode.getEnvironment().getTimeSource().currentTimeMillis() - 5000L) {
            long currentTime = this.localNode.getEnvironment().getTimeSource().currentTimeMillis();
            if (this.logger.level <= 500) {
                this.logger.log("PeriodicLeafSetProtocol: Checking liveness on neighbor:" + sendTo + " " + time);
            }
            this.lastTimeSentBLS.put(sendTo, new Long(currentTime));
            this.thePastryNode.send(sendTo, new BroadcastLeafSet(this.localHandle, this.leafSet, 0, 0L));
            this.thePastryNode.send(sendTo, new RequestLeafSet(this.localHandle, currentTime));
            sendTo.checkLiveness();
            return true;
        }
        return false;
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("PLSP: destroy() called");
        }
        this.pingNeighborMessage.cancel();
    }

    public static class PLSPMessageDeserializer
    extends PJavaSerializedDeserializer {
        public PLSPMessageDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return new RequestLeafSet(sender, buf);
                }
                case 2: {
                    return new BroadcastLeafSet(buf, this.pn);
                }
            }
            return null;
        }
    }
}

