/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.join.JoinAddress;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.PRawMessage;

public class ConsistentJoinMsg
extends PRawMessage {
    LeafSet ls;
    boolean request;
    HashSet failed;
    private static final long serialVersionUID = -8942404626084999673L;
    public static final short TYPE = 2;

    public ConsistentJoinMsg(LeafSet ls, HashSet failed, boolean request) {
        super(JoinAddress.getCode());
        this.ls = ls;
        this.request = request;
        this.failed = failed;
    }

    public ConsistentJoinMsg(InputBuffer buf, NodeHandleFactory nhf, NodeHandle sender) throws IOException {
        super(JoinAddress.getCode());
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.setSender(sender);
                this.ls = LeafSet.build(buf, nhf);
                this.request = buf.readBoolean();
                this.failed = new HashSet();
                int numInSet = buf.readInt();
                for (int i = 0; i < numInSet; ++i) {
                    this.failed.add(nhf.readNodeHandle(buf));
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public short getType() {
        return 2;
    }

    public String toString() {
        return "ConsistentJoinMsg " + this.ls + " request:" + this.request;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.ls.serialize(buf);
        buf.writeBoolean(this.request);
        buf.writeInt(this.failed.size());
        Iterator i = this.failed.iterator();
        while (i.hasNext()) {
            NodeHandle h = (NodeHandle)i.next();
            h.serialize(buf);
        }
    }
}

