/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.messaging;

import java.io.IOException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandleFactory;
import rice.pastry.routing.RouteSet;
import rice.pastry.socket.messaging.SocketMessage;

public class RouteRowResponseMessage
extends SocketMessage {
    private RouteSet[] set;
    public static final short TYPE = 11;

    public RouteRowResponseMessage(RouteSet[] set) {
        this.set = set;
    }

    public RouteRowResponseMessage(InputBuffer buf, NodeHandleFactory nhf) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                int numRouteSets = buf.readInt();
                this.set = new RouteSet[numRouteSets];
                for (int i = 0; i < numRouteSets; ++i) {
                    if (!buf.readBoolean()) continue;
                    this.set[i] = new RouteSet(buf, nhf);
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public RouteSet[] getRouteRow() {
        return this.set;
    }

    public short getType() {
        return 11;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeInt(this.set.length);
        for (int i = 0; i < this.set.length; ++i) {
            if (this.set[i] == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            this.set[i].serialize(buf);
        }
    }
}

