/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.messaging;

import java.io.IOException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.socket.messaging.SocketMessage;

public class NodeIdResponseMessage
extends SocketMessage {
    private Id nid;
    private long epoch;
    public static final short TYPE = 7;

    public NodeIdResponseMessage(Id nid, long epoch) {
        this.nid = nid;
        this.epoch = epoch;
    }

    public NodeIdResponseMessage(InputBuffer buf) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.nid = Id.build(buf);
                this.epoch = buf.readLong();
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public Id getNodeId() {
        return this.nid;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public short getType() {
        return 7;
    }

    public String toString() {
        return "NodeIdResponseMessage[" + this.nid + "," + this.epoch + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.nid.serialize(buf);
        buf.writeLong(this.epoch);
    }
}

