/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.messaging;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.socket.messaging.DatagramMessage;

public class IPAddressResponseMessage
extends DatagramMessage {
    protected InetSocketAddress address;
    public static final short TYPE = 3;

    public IPAddressResponseMessage(InetSocketAddress address, long start) {
        super(start);
        this.address = address;
    }

    public IPAddressResponseMessage(InputBuffer buf) throws IOException {
        super(buf.readLong());
        byte[] addr = new byte[4];
        buf.read(addr);
        this.address = new InetSocketAddress(InetAddress.getByAddress(addr), buf.readInt());
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public short getType() {
        return 3;
    }

    public String toString() {
        return "IPAddressResponseMessage";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.start);
        byte[] addr = this.address.getAddress().getAddress();
        buf.write(addr, 0, addr.length);
        buf.writeInt(this.address.getPort());
    }
}

