/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.NodeIsDeadException;
import rice.p2p.util.TimerWeakHashMap;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PendingAppSocket;
import rice.pastry.socket.SocketBuffer;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketSourceRouteManager {
    public long CHECK_DEAD_THROTTLE;
    public long PING_THROTTLE;
    public int NUM_SOURCE_ROUTE_ATTEMPTS;
    private SocketPastryNode spn;
    private SocketCollectionManager manager;
    private EpochInetSocketAddress localAddress;
    private Logger logger;
    HashSet hardLinks = new HashSet();
    TimerWeakHashMap nodeHandles;

    protected SocketSourceRouteManager(SocketPastryNode node, EpochInetSocketAddress bindAddress, EpochInetSocketAddress proxyAddress, RandomSource random) throws IOException {
        this.spn = node;
        Parameters p = node.getEnvironment().getParameters();
        this.CHECK_DEAD_THROTTLE = p.getLong("pastry_socket_srm_check_dead_throttle");
        this.PING_THROTTLE = p.getLong("pastry_socket_srm_ping_throttle");
        this.NUM_SOURCE_ROUTE_ATTEMPTS = p.getInt("pastry_socket_srm_num_source_route_attempts");
        this.nodeHandles = new TimerWeakHashMap(node.getEnvironment().getSelectorManager().getTimer(), 30000);
        this.logger = node.getEnvironment().getLogManager().getLogger(SocketSourceRouteManager.class, null);
        this.manager = new SocketCollectionManager(node, this, bindAddress, proxyAddress, random);
        this.localAddress = bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getBest() {
        HashMap result = new HashMap();
        TimerWeakHashMap timerWeakHashMap = this.nodeHandles;
        synchronized (timerWeakHashMap) {
            Iterator i = this.nodeHandles.keySet().iterator();
            while (i.hasNext()) {
                AddressManager am;
                SocketNodeHandle snh;
                Object addr = i.next();
                WeakReference wr = (WeakReference)this.nodeHandles.get(addr);
                if (wr == null || (snh = (SocketNodeHandle)wr.get()) == null || (am = snh.addressManager) == null || am.getLiveness() >= 3) continue;
                result.put(addr, am.best);
            }
        }
        return result;
    }

    public SocketCollectionManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AddressManager getAddressManager(EpochInetSocketAddress address, boolean search) {
        TimerWeakHashMap timerWeakHashMap = this.nodeHandles;
        synchronized (timerWeakHashMap) {
            AddressManager manager = this.getAddressManager(address);
            if (manager == null) {
                manager = this.putAddressManager(address, search);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketNodeHandle getNodeHandle(EpochInetSocketAddress address) {
        TimerWeakHashMap timerWeakHashMap = this.nodeHandles;
        synchronized (timerWeakHashMap) {
            WeakReference wr = (WeakReference)this.nodeHandles.get(address);
            if (wr == null) {
                return null;
            }
            SocketNodeHandle ret = (SocketNodeHandle)wr.get();
            if (ret == null) {
                return null;
            }
            if (ret.getNodeId() == null) {
                return null;
            }
            return ret;
        }
    }

    public AddressManager getAddressManager(EpochInetSocketAddress address) {
        WeakReference wr = (WeakReference)this.nodeHandles.get(address);
        if (wr == null) {
            return null;
        }
        SocketNodeHandle snh = (SocketNodeHandle)wr.get();
        if (snh == null) {
            return null;
        }
        return snh.addressManager;
    }

    public int getLiveness(EpochInetSocketAddress address) {
        return this.getAddressManager(address, true).getLiveness();
    }

    protected SourceRoute[] getAllRoutes(EpochInetSocketAddress destination) {
        Vector result = new Vector(this.NUM_SOURCE_ROUTE_ATTEMPTS);
        this.walkLeafSet(destination, this.NUM_SOURCE_ROUTE_ATTEMPTS, result);
        LinkedList ll = new LinkedList();
        while (result.size() > 0) {
            ll.add(result.remove(this.spn.getEnvironment().getRandomSource().nextInt(result.size())));
        }
        ll.addFirst(SourceRoute.build(destination));
        if (this.logger.level <= 400) {
            String s = "";
            Iterator i = ll.iterator();
            while (i.hasNext()) {
                s = s + " " + i.next();
            }
            this.logger.log("getAllRoutes(" + destination + "):" + ll.size() + "," + this.spn.getLeafSet().getUniqueCount() + "/" + this.NUM_SOURCE_ROUTE_ATTEMPTS + s);
        } else if (this.logger.level <= 500) {
            this.logger.log("getAllRoutes(" + destination + "):" + ll.size() + "," + this.spn.getLeafSet().getUniqueCount() + "/" + this.NUM_SOURCE_ROUTE_ATTEMPTS);
        }
        return ll.toArray(new SourceRoute[0]);
    }

    protected SourceRoute getBestRoute(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am == null || am.getLiveness() == 3 || am.getLiveness() == 4) {
            return null;
        }
        return am.best;
    }

    public void destroy() throws IOException {
        if (this.spn.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.manager.destroy();
        } else {
            this.spn.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            SocketSourceRouteManager.this.destroy();
                        }
                        catch (IOException ioe) {
                            if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break block2;
                            SocketSourceRouteManager.this.logger.logException("Exception while destrying SocketSourceRouteManager", ioe);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeHandle coalesce(NodeHandle newHandle) {
        SocketNodeHandle snh = (SocketNodeHandle)newHandle;
        TimerWeakHashMap timerWeakHashMap = this.nodeHandles;
        synchronized (timerWeakHashMap) {
            WeakReference wr = (WeakReference)this.nodeHandles.get(snh.eaddress);
            if (wr == null) {
                this.addNodeHandle(snh);
                return snh;
            }
            SocketNodeHandle ret = (SocketNodeHandle)wr.get();
            if (ret == null) {
                this.addNodeHandle(snh);
                return snh;
            }
            if (ret.getNodeId() == null) {
                ret.setNodeId(newHandle.getNodeId());
            }
            return ret;
        }
    }

    private void addNodeHandle(SocketNodeHandle snh) {
        WeakReference<SocketNodeHandle> wr = new WeakReference<SocketNodeHandle>(snh);
        this.nodeHandles.put(snh.eaddress, wr);
        snh.setLocalNode(this.spn);
    }

    public AddressManager putAddressManager(EpochInetSocketAddress address, boolean search) {
        SocketNodeHandle snh;
        WeakReference<SocketNodeHandle> wr = (WeakReference<SocketNodeHandle>)this.nodeHandles.get(address);
        if (wr == null) {
            snh = new SocketNodeHandle(address, null);
            snh.setLocalNode(this.spn);
            wr = new WeakReference<SocketNodeHandle>(snh);
            this.nodeHandles.put(address, wr);
        } else {
            snh = (SocketNodeHandle)wr.get();
            if (snh == null) {
                snh = new SocketNodeHandle(address, null);
                snh.setLocalNode(this.spn);
                wr = new WeakReference<SocketNodeHandle>(snh);
                this.nodeHandles.put(address, wr);
            }
        }
        if (snh.addressManager != null) {
            throw new IllegalStateException("Address manager for address " + address + " already exists.");
        }
        AddressManager manager = new AddressManager(snh, search);
        this.nodeHandles.refresh(manager);
        snh.addressManager = manager;
        return manager;
    }

    public void bootstrap(EpochInetSocketAddress address, Message msg) throws IOException {
        this.manager.bootstrap(SourceRoute.build(address), msg);
    }

    public void send(EpochInetSocketAddress address, Message msg) throws IOException {
        PRawMessage rm = msg instanceof PRawMessage ? (PRawMessage)msg : new PJavaSerializedMessage(msg);
        SocketBuffer buffer = new SocketBuffer(this.manager.defaultDeserializer, (NodeHandleFactory)this.manager.pastryNode);
        buffer.serialize(rm, true);
        this.send(address, buffer);
    }

    public void send(final EpochInetSocketAddress address, final SocketBuffer message) {
        if (this.spn.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.getAddressManager(address, true).send(message);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("Application attempted to send " + message + " to " + address + " on a non-selector thread.");
            }
            this.spn.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    SocketSourceRouteManager.this.getAddressManager(address, true).send(message);
                }
            });
        }
    }

    public void connect(final EpochInetSocketAddress address, final int appAddress, final AppSocketReceiver receiver, final int timeout) {
        if (this.spn.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.getAddressManager(address, true).connect(appAddress, receiver, timeout);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("Application " + appAddress + " attempted to open a connection to " + address + " on a non-selector thread.");
            }
            this.spn.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    SocketSourceRouteManager.this.getAddressManager(address, true).connect(appAddress, receiver, timeout);
                }
            });
        }
    }

    public void ping(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am == null) {
            this.manager.ping(SourceRoute.build(address));
        } else {
            am.ping();
        }
    }

    public void checkLiveness(EpochInetSocketAddress address) {
        this.getAddressManager(address, true).checkLiveness();
    }

    public int proximity(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am == null) {
            return SocketNodeHandle.DEFAULT_PROXIMITY;
        }
        return am.proximity();
    }

    protected void markDead(SourceRoute route) {
        AddressManager am;
        if (this.logger.level <= 500) {
            this.logger.log("(SSRM) Found route " + route + " to be dead");
        }
        if ((am = this.getAddressManager(route.getLastHop())) != null) {
            am.markDead(route);
        }
    }

    protected void markDead(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am != null) {
            am.markDeadForever();
        }
    }

    protected void markAlive(SourceRoute route) {
        if (this.logger.level <= 500) {
            this.logger.log("(SSRM) Found route " + route + " to be alive");
        }
        this.getAddressManager(route.getLastHop(), false).markAlive(route);
    }

    protected int proximity(SourceRoute route) {
        return this.getAddressManager(route.getLastHop(), false).proximity();
    }

    protected void markSuspected(SourceRoute route) {
        if (this.logger.level <= 500) {
            this.logger.log("(SSRM) Found route " + route + " to be suspected");
        }
        this.getAddressManager(route.getLastHop(), false).markSuspected(route);
    }

    protected synchronized void markProximity(SourceRoute route, int proximity) {
        this.getAddressManager(route.getLastHop(), false).markProximity(route, proximity);
    }

    protected void reroute(EpochInetSocketAddress address, SocketBuffer m) {
        if (m.discard) {
            if (this.logger.level <= 500) {
                this.logger.log("(SSRM) Dropping garbage in resend message " + m + " address " + address + " with liveness " + this.getLiveness(address));
            }
            return;
        }
        switch (this.getLiveness(address)) {
            case 1: {
                if (this.logger.level <= 800) {
                    this.logger.log("(SSRM) Attempting to resend message " + m + " to alive address " + address);
                }
                this.send(address, m);
                return;
            }
            case 2: {
                if (m.isRouteMessage()) {
                    if (m.getOptions().multipleHopsAllowed() && m.getOptions().rerouteIfSuspected()) {
                        if (this.logger.level <= 800) {
                            this.logger.log("(SSRM) Attempting to reroute route message " + m);
                        }
                        RouteMessage rm = m.getRouteMessage();
                        rm.nextHop = null;
                        this.spn.receiveMessage(rm);
                        return;
                    }
                } else {
                    if (this.logger.level <= 800) {
                        this.logger.log("(SSRM) Attempting to resend message " + m + " to alive address " + address);
                    }
                    this.send(address, m);
                    return;
                }
            }
            case 3: 
            case 4: {
                if (!m.isRouteMessage() || !m.getOptions().multipleHopsAllowed()) break;
                if (this.logger.level <= 800) {
                    this.logger.log("(SSRM) Attempting to reroute route message " + m);
                }
                RouteMessage rm = m.getRouteMessage();
                rm.nextHop = null;
                this.spn.receiveMessage(rm);
                return;
            }
        }
        if (this.logger.level <= 900) {
            this.logger.log("(SSRM) Dropping message " + m + " because next hop " + address + " is dead!");
        }
    }

    private Collection walkLeafSet(EpochInetSocketAddress destination, int numRequested, Collection result) {
        LeafSet leafset = this.spn.getLeafSet();
        for (int i = 1; i < leafset.maxSize() / 2; ++i) {
            SocketNodeHandle snh = (SocketNodeHandle)leafset.get(-i);
            if (this.addMember(snh, destination, result) && --numRequested == 0) {
                return result;
            }
            snh = (SocketNodeHandle)leafset.get(i);
            if (!this.addMember(snh, destination, result) || --numRequested != 0) continue;
            return result;
        }
        return result;
    }

    private boolean addMember(SocketNodeHandle handle, EpochInetSocketAddress destination, Collection result) {
        if (!(handle == null || handle.isLocal() || handle.getEpochAddress().equals(destination) || this.getBestRoute(handle.getEpochAddress()) == null || this.getBestRoute(handle.getEpochAddress()).goesThrough(destination))) {
            result.add(this.getBestRoute(handle.getEpochAddress()).append(destination));
            return true;
        }
        return false;
    }

    protected class AddressManager {
        protected SocketNodeHandle address;
        protected SourceRoute best;
        protected LinkedList queue;
        protected LinkedList pendingAppSockets;
        protected HashMap routes;
        protected int liveness;
        protected long updated;

        public AddressManager(SocketNodeHandle address, boolean search) {
            this.address = address;
            this.queue = new LinkedList();
            this.pendingAppSockets = new LinkedList();
            this.routes = new HashMap();
            this.liveness = 2;
            this.updated = 0L;
            if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                SocketSourceRouteManager.this.logger.log("(SSRM) ADDRESS MANAGER CREATED AT " + SocketSourceRouteManager.this.localAddress + " FOR " + address);
            }
            if (search) {
                this.getRouteManager(SourceRoute.build(address.eaddress)).checkLiveness();
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            }
        }

        protected SourceRouteManager getRouteManager(SourceRoute route) {
            if (route == null) {
                throw new IllegalArgumentException("route is null in " + this.toString());
            }
            SourceRouteManager result = (SourceRouteManager)this.routes.get(route);
            if (result == null) {
                result = new SourceRouteManager(route);
                this.routes.put(route, result);
            }
            return result;
        }

        public int getLiveness() {
            return this.liveness;
        }

        protected void setAlive() {
            if (this.best == null) {
                throw new IllegalStateException("best is null in " + this.toString());
            }
            while (!this.queue.isEmpty()) {
                this.getRouteManager(this.best).send((SocketBuffer)this.queue.removeFirst());
            }
            while (!this.pendingAppSockets.isEmpty()) {
                PendingAppSocket pas = (PendingAppSocket)this.pendingAppSockets.removeFirst();
                this.getRouteManager(this.best).connect(pas.appAddress, pas.receiver, 0);
            }
            if (this.queue.isEmpty() && this.pendingAppSockets.isEmpty()) {
                SocketSourceRouteManager.this.hardLinks.remove(this);
            }
            switch (this.liveness) {
                case 3: {
                    this.liveness = 1;
                    if (this.address != null) {
                        this.address.update(SocketNodeHandle.DECLARED_LIVE);
                    }
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be alive again.");
                    break;
                }
                case 2: {
                    this.liveness = 1;
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be unsuspected.");
                    break;
                }
                case 4: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found dead-forever handle to " + this.address + " to be alive again!");
                }
            }
        }

        protected void setSuspected() {
            switch (this.liveness) {
                case 1: {
                    this.liveness = 2;
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis() + " " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be suspected.");
                    break;
                }
                case 3: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found node handle " + this.address + " to be suspected from dead - should not happen!");
                    break;
                }
                case 4: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found node handle " + this.address + " to be suspected from dead forever - should never ever happen!");
                }
            }
            Object[] array = this.queue.toArray();
            for (int i = 0; i < array.length; ++i) {
                SocketBuffer sb = (SocketBuffer)array[i];
                if (!sb.isRouteMessage() || !sb.getOptions().multipleHopsAllowed() || !sb.getOptions().rerouteIfSuspected()) continue;
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("REROUTE: Rerouting message " + sb + " due to suspected next hop " + this.address);
                }
                SocketSourceRouteManager.this.reroute(this.address.eaddress, sb);
                this.queue.remove(sb);
            }
            if (this.queue.isEmpty() && this.pendingAppSockets.isEmpty()) {
                SocketSourceRouteManager.this.hardLinks.remove(this);
            }
        }

        protected void setDead() {
            switch (this.liveness) {
                case 3: {
                    return;
                }
                case 4: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found node handle " + this.address + " to be dead from dead forever - should not happen!");
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 3;
                    if (this.address != null) {
                        this.address.update(SocketNodeHandle.DECLARED_DEAD);
                    }
                    SocketSourceRouteManager.this.manager.declaredDead(this.address.eaddress);
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be dead.");
                }
            }
            this.purgeQueue();
        }

        protected void setDeadForever() {
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    this.liveness = 4;
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be dead forever.");
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 4;
                    if (this.address != null) {
                        this.address.update(SocketNodeHandle.DECLARED_DEAD);
                    }
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be dead forever.");
                }
            }
            this.purgeQueue();
        }

        public int proximity() {
            if (this.best == null) {
                return SocketNodeHandle.DEFAULT_PROXIMITY;
            }
            return this.getRouteManager(this.best).proximity();
        }

        protected synchronized void markAlive(SourceRoute route) {
            this.getRouteManager(route).markAlive();
            if (this.best == null) {
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("(SSRM) No previous best route existed to " + this.address + " route " + route + " is now the best");
                }
                this.best = route;
            }
            if (this.best.getNumHops() > route.getNumHops() || this.best.getNumHops() == route.getNumHops() && this.getRouteManager(this.best).proximity() > this.getRouteManager(route).proximity()) {
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("(SSRM) Route " + route + " is better than previous best route " + this.best + " - replacing");
                }
                this.best = route;
                if (this.address != null) {
                    this.address.update(SocketNodeHandle.PROXIMITY_CHANGED);
                }
            }
            this.setAlive();
        }

        protected synchronized void markSuspected(SourceRoute route) {
            this.getRouteManager(route).markSuspected();
            if ((this.best == null || this.best.equals(route)) && this.liveness < 3) {
                this.setSuspected();
            }
        }

        protected synchronized void markDead(SourceRoute route) {
            this.getRouteManager(route).markDead();
            if (this.liveness >= 3) {
                return;
            }
            if (this.best == null || route.equals(this.best)) {
                this.best = null;
                SourceRoute[] routes = SocketSourceRouteManager.this.getAllRoutes(route.getLastHop());
                boolean found = false;
                for (int i = 0; i < routes.length; ++i) {
                    if (!this.getRouteManager(routes[i]).checkLiveness()) continue;
                    found = true;
                }
                if (!found) {
                    this.setDead();
                }
            }
        }

        protected synchronized void markDeadForever() {
            this.best = null;
            this.setDeadForever();
        }

        protected synchronized void markProximity(SourceRoute route, int proximity) {
            this.getRouteManager(route).markAlive();
            this.getRouteManager(route).markProximity(proximity);
            if (this.best == null) {
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("(SSRM) No previous best route existed to " + this.address + " route " + route + " is now the best");
                }
                this.best = route;
            }
            this.setAlive();
            if (route.equals(this.best) && this.address != null) {
                this.address.update(SocketNodeHandle.PROXIMITY_CHANGED);
            }
        }

        public synchronized void send(SocketBuffer message) {
            if (this.liveness == 3) {
                this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            }
            if (this.best == null) {
                this.queue.addLast(message);
                SocketSourceRouteManager.this.hardLinks.add(this);
            } else if (!this.getRouteManager(this.best).isOpen()) {
                this.queue.addLast(message);
                SocketSourceRouteManager.this.hardLinks.add(this);
                this.getRouteManager(this.best).checkLiveness();
                this.best = null;
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            } else {
                this.getRouteManager(this.best).send(message);
            }
        }

        public synchronized void connect(int appAddress, AppSocketReceiver receiver, int timeout) {
            if (this.liveness == 3) {
                this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            }
            if (this.best == null) {
                this.pendingAppSockets.addLast(new PendingAppSocket(appAddress, receiver));
                SocketSourceRouteManager.this.hardLinks.add(this);
            } else if (!this.getRouteManager(this.best).isOpen()) {
                this.pendingAppSockets.addLast(new PendingAppSocket(appAddress, receiver));
                SocketSourceRouteManager.this.hardLinks.add(this);
                this.getRouteManager(this.best).checkLiveness();
                this.best = null;
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            } else {
                this.getRouteManager(this.best).connect(appAddress, receiver, timeout);
            }
        }

        public void ping() {
            if (SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis() - this.updated > SocketSourceRouteManager.this.PING_THROTTLE) {
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
                switch (this.liveness) {
                    case 4: {
                        return;
                    }
                    case 3: {
                        if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                            SocketSourceRouteManager.this.logger.log("(SSRM) PING: PINGING DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY");
                        }
                        this.getRouteManager(SourceRoute.build(this.address.eaddress)).ping();
                        break;
                    }
                    default: {
                        if (this.best == null) break;
                        this.getRouteManager(this.best).ping();
                        if (this.best.isDirect()) break;
                        this.getRouteManager(SourceRoute.build(this.address.eaddress)).ping();
                    }
                }
            }
        }

        public void checkLiveness() {
            this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                        SocketSourceRouteManager.this.logger.log("(SSRM) CHECKLIVENESS: CHECKING DEAD ON DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY");
                    }
                    this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                    break;
                }
                default: {
                    if (this.best == null) break;
                    this.getRouteManager(this.best).checkLiveness();
                    if (this.best.isDirect()) break;
                    this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                }
            }
        }

        protected void purgeQueue() {
            while (!this.queue.isEmpty()) {
                SocketSourceRouteManager.this.reroute(this.address.eaddress, (SocketBuffer)this.queue.removeFirst());
            }
            while (!this.pendingAppSockets.isEmpty()) {
                PendingAppSocket pas = (PendingAppSocket)this.pendingAppSockets.removeFirst();
                pas.receiver.receiveException(null, new NodeIsDeadException());
            }
            SocketSourceRouteManager.this.hardLinks.remove(this);
        }

        public class SourceRouteManager {
            protected SourceRoute route;
            protected int liveness;
            protected int proximity;
            protected long updated;
            protected boolean pending;

            public SourceRouteManager(SourceRoute route) {
                if (route == null) {
                    throw new IllegalArgumentException("route is null");
                }
                this.route = route;
                this.liveness = 2;
                this.proximity = SocketNodeHandle.DEFAULT_PROXIMITY;
                this.pending = false;
                this.updated = 0L;
            }

            public boolean isOpen() {
                return SocketSourceRouteManager.this.manager.isOpen(this.route);
            }

            public int proximity() {
                return this.proximity;
            }

            protected void markAlive() {
                this.liveness = 1;
                this.pending = false;
            }

            protected void markSuspected() {
                this.liveness = 2;
            }

            protected void markDead() {
                this.liveness = 3;
                this.pending = false;
            }

            protected void markProximity(int proximity) {
                if (proximity < 0) {
                    throw new IllegalArgumentException("proximity must be >= 0, was:" + proximity);
                }
                if (this.proximity > proximity) {
                    this.proximity = proximity;
                }
            }

            protected boolean checkLiveness() {
                if (this.pending) {
                    return true;
                }
                if (this.liveness < 3 || this.updated < SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis() - ((AddressManager)AddressManager.this).SocketSourceRouteManager.this.CHECK_DEAD_THROTTLE) {
                    this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
                    this.pending = true;
                    SocketSourceRouteManager.this.manager.checkLiveness(this.route);
                    return true;
                }
                return false;
            }

            public synchronized void send(SocketBuffer message) {
                SocketSourceRouteManager.this.manager.send(this.route, message, AddressManager.this);
            }

            public synchronized void connect(int appId, AppSocketReceiver receiver, int timeout) {
                SocketSourceRouteManager.this.manager.connect(this.route, appId, receiver, timeout);
            }

            public void ping() {
                SocketSourceRouteManager.this.manager.ping(this.route);
            }
        }
    }
}

