/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Observable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.messaging.Message;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;

public class SocketNodeHandle
extends DistNodeHandle {
    protected EpochInetSocketAddress eaddress;
    transient SocketSourceRouteManager.AddressManager addressManager;
    static final long serialVersionUID = -5452528188786429274L;
    public static final int LIVENESS_DEAD_FOREVER = 4;
    public static int DEFAULT_PROXIMITY = Integer.MAX_VALUE;

    public SocketNodeHandle(EpochInetSocketAddress address, Id nodeId) {
        super(nodeId, address.getAddress());
        this.eaddress = address;
    }

    public EpochInetSocketAddress getEpochAddress() {
        return this.eaddress;
    }

    public int getLiveness() {
        InetSocketAddress myAddress;
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn == null || this.getLocalNode().getLocalHandle() == null) {
            return 1;
        }
        if (this.isLocal()) {
            return 1;
        }
        EpochInetSocketAddress localEaddr = ((SocketNodeHandle)this.getLocalNode().getLocalHandle()).getEpochAddress();
        InetSocketAddress localAddress = localEaddr.getAddress();
        if (localAddress.equals(myAddress = this.getEpochAddress().getAddress()) && !this.getEpochAddress().equals(localEaddr)) {
            return 4;
        }
        return spn.getSocketSourceRouteManager().getLiveness(this.getEpochAddress());
    }

    public boolean isLocal() {
        this.assertLocalNode();
        return this.getLocalNode().getLocalHandle().equals(this);
    }

    public void setNodeId(Id nodeId) {
        this.nodeId = nodeId;
    }

    public void setLocalNode(SocketPastryNode spn) {
        this.localnode = spn;
        this.logger = spn.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    public void markDeadForever() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        spn.getSocketSourceRouteManager().getAddressManager(this.getEpochAddress(), false).markDeadForever();
    }

    public boolean checkLiveness() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn != null) {
            spn.getSocketSourceRouteManager().checkLiveness(this.getEpochAddress());
        }
        return this.isAlive();
    }

    public void receiveMessage(Message msg) {
        this.assertLocalNode();
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        try {
            if (spn.getNodeId().equals(this.nodeId)) {
                spn.receiveMessage(msg);
            } else {
                if (this.logger.level <= 400) {
                    this.logger.log("Passing message " + msg + " to the socket controller for writing");
                }
                spn.getSocketSourceRouteManager().send(this.getEpochAddress(), msg);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void bootstrap(Message msg) throws IOException {
        ((SocketPastryNode)this.getLocalNode()).getSocketSourceRouteManager().bootstrap(this.getEpochAddress(), msg);
    }

    public String toString() {
        if (this.getLocalNode() == null) {
            return "[SNH: " + this.nodeId + "/" + this.getEpochAddress() + "]";
        }
        return "[SNH: " + this.getLocalNode().getNodeId() + " -> " + this.nodeId + "/" + this.getEpochAddress() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SocketNodeHandle)) {
            return false;
        }
        SocketNodeHandle other = (SocketNodeHandle)obj;
        return other.getNodeId().equals(this.getNodeId()) && other.eaddress.equals(this.eaddress);
    }

    public int hashCode() {
        return this.getNodeId().hashCode() ^ this.eaddress.hashCode();
    }

    public int proximity() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn == null) {
            return DEFAULT_PROXIMITY;
        }
        if (spn.getNodeId().equals(this.nodeId)) {
            return 0;
        }
        return spn.getSocketSourceRouteManager().proximity(this.getEpochAddress());
    }

    public boolean ping() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn != null && spn.srManager != null) {
            spn.srManager.ping(this.getEpochAddress());
        }
        return this.isAlive();
    }

    public void update(Observable o, Object obj) {
    }

    protected void update(Object update) {
        if (this.logger != null && this.logger.level <= 500) {
            this.logger.log(this + ".update(" + update + ")" + this.countObservers());
        }
        this.setChanged();
        this.notifyObservers(update);
        if (this.logger != null && this.logger.level <= 300) {
            this.logger.log(this + ".update(" + update + ")" + this.countObservers() + " done");
        }
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.eaddress.serialize(buf);
        this.nodeId.serialize(buf);
    }

    static SocketNodeHandle build(InputBuffer buf) throws IOException {
        EpochInetSocketAddress eaddr = EpochInetSocketAddress.build(buf);
        Id nid = Id.build(buf);
        return new SocketNodeHandle(eaddr, nid);
    }
}

