/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class EpochInetSocketAddress
implements Serializable {
    protected InetSocketAddress address;
    protected long epoch;
    private static final long serialVersionUID = 2081191512212313338L;
    public static final long EPOCH_UNKNOWN = -1L;

    public EpochInetSocketAddress(InetSocketAddress address) {
        this(address, -1L);
    }

    public EpochInetSocketAddress(InetSocketAddress address, long epoch) {
        this.address = address;
        this.epoch = epoch;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public int hashCode() {
        return (int)((long)this.address.hashCode() ^ this.epoch);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        EpochInetSocketAddress that = (EpochInetSocketAddress)o;
        if (this.epoch != that.epoch) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public String toString() {
        return this.address.toString() + " [" + this.epoch + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.write(this.address.getAddress().getAddress(), 0, 4);
        buf.writeInt(this.address.getPort());
        buf.writeLong(this.epoch);
    }

    public static EpochInetSocketAddress build(InputBuffer buf) throws IOException {
        byte[] addrBytes = new byte[4];
        buf.read(addrBytes);
        InetAddress addr = InetAddress.getByAddress(addrBytes);
        int port = buf.readInt();
        InetSocketAddress saddr = new InetSocketAddress(addr, port);
        long epoch = buf.readLong();
        return new EpochInetSocketAddress(saddr, epoch);
    }
}

