/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SendOptions
implements Serializable {
    private boolean random;
    private boolean noShortCuts;
    private boolean shortestPath;
    private boolean allowMultipleHops;
    private boolean rerouteIfSuspected;
    public static final boolean defaultRandom = false;
    public static final boolean defaultNoShortCuts = true;
    public static final boolean defaultShortestPath = true;
    public static final boolean defaultAllowMultipleHops = true;
    public static final boolean defaultRerouteIfSuspected = true;

    public SendOptions() {
        this.random = false;
        this.noShortCuts = true;
        this.shortestPath = true;
        this.allowMultipleHops = true;
        this.rerouteIfSuspected = true;
    }

    public SendOptions(boolean random, boolean noShortCuts, boolean shortestPath, boolean allowMultipleHops, boolean rerouteIfSuspected) {
        this.random = random;
        this.noShortCuts = noShortCuts;
        this.shortestPath = shortestPath;
        this.allowMultipleHops = allowMultipleHops;
        this.rerouteIfSuspected = rerouteIfSuspected;
    }

    public void setMultipleHopsAllowed(boolean b) {
        this.allowMultipleHops = b;
    }

    public void setRerouteIfSuspected(boolean b) {
        this.rerouteIfSuspected = b;
    }

    public boolean canRandom() {
        return this.random;
    }

    public boolean makeNoShortCuts() {
        return this.noShortCuts;
    }

    public boolean requireShortestPath() {
        return this.shortestPath;
    }

    public boolean multipleHopsAllowed() {
        return this.allowMultipleHops;
    }

    public boolean rerouteIfSuspected() {
        return this.rerouteIfSuspected;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.random = in.readBoolean();
        this.noShortCuts = in.readBoolean();
        this.shortestPath = in.readBoolean();
        this.allowMultipleHops = in.readBoolean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.writeBoolean(this.random);
        out.writeBoolean(this.noShortCuts);
        out.writeBoolean(this.shortestPath);
        out.writeBoolean(this.allowMultipleHops);
    }
}

