/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeSetI;
import rice.pastry.routing.RoutingTable;

public class RouteSet
implements NodeSetI,
Serializable,
Observer {
    private NodeHandle[] nodes;
    private int theSize;
    private int closest;
    transient RoutingTable observer;
    public static final short TYPE = 2;
    private static final long serialVersionUID = 8156336294555109590L;

    public RouteSet(int maxSize) {
        this.nodes = new NodeHandle[maxSize];
        this.theSize = 0;
        this.closest = -1;
    }

    public RouteSet(InputBuffer buf, NodeHandleFactory nhf) throws IOException {
        byte maxSize = buf.readByte();
        this.theSize = buf.readByte();
        this.closest = buf.readByte();
        this.nodes = new NodeHandle[maxSize];
        for (int i = 0; i < this.theSize; ++i) {
            this.nodes[i] = nhf.readNodeHandle(buf);
        }
    }

    public NodeHandle get(int i) {
        if (i < 0 || i >= this.theSize) {
            throw new NoSuchElementException();
        }
        return this.nodes[i];
    }

    public NodeHandle get(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public int getIndex(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return i;
        }
        return -1;
    }

    public rice.p2p.commonapi.NodeHandle getHandle(rice.p2p.commonapi.Id id) {
        return this.getHandle((Id)id);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(int i) {
        return this.get(i);
    }

    public int getIndexHandle(rice.p2p.commonapi.Id id) throws NoSuchElementException {
        return this.getIndex((Id)id);
    }

    public short getType() {
        return 2;
    }

    public void setRoutingTable(RoutingTable rt) {
        this.observer = rt;
    }

    public String toString() {
        String s = "RS: ";
        for (int i = 0; i < this.nodes.length; ++i) {
            s = s + this.nodes[i] + ",";
        }
        return s;
    }

    public boolean put(NodeHandle handle) {
        int worstIndex = -1;
        int worstProximity = Integer.MIN_VALUE;
        for (int i = 0; i < this.theSize; ++i) {
            if (this.nodes[i].equals(handle)) {
                return false;
            }
            int p = this.nodes[i].proximity();
            if (p < worstProximity) continue;
            worstProximity = p;
            worstIndex = i;
        }
        if (this.theSize < this.nodes.length) {
            this.nodes[this.theSize++] = handle;
            this.notifyTable(handle, true);
            handle.ping();
            handle.addObserver(this);
            return true;
        }
        if (handle.proximity() == Integer.MAX_VALUE) {
            handle.ping();
            handle.addObserver(this);
            return false;
        }
        if (handle.proximity() < worstProximity) {
            this.notifyTable(this.nodes[worstIndex], false);
            this.nodes[worstIndex].deleteObserver(this);
            this.nodes[worstIndex] = handle;
            this.notifyTable(handle, true);
            handle.addObserver(this);
            return true;
        }
        return false;
    }

    public void update(Observable o, Object arg) {
        if ((Integer)arg == NodeHandle.PROXIMITY_CHANGED) {
            this.put((NodeHandle)o);
        } else if ((Integer)arg == NodeHandle.DECLARED_DEAD) {
            this.remove((NodeHandle)o);
        }
    }

    public NodeHandle remove(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            NodeHandle handle = this.nodes[i];
            this.nodes[i] = this.nodes[--this.theSize];
            this.notifyTable(handle, false);
            handle.deleteObserver(this);
            return handle;
        }
        return null;
    }

    public NodeHandle remove(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            NodeHandle handle = this.nodes[i];
            this.nodes[i] = this.nodes[--this.theSize];
            this.notifyTable(handle, false);
            handle.deleteObserver(this);
            return handle;
        }
        return null;
    }

    private void notifyTable(NodeHandle handle, boolean added) {
        if (this.observer != null) {
            this.observer.nodeSetUpdate(null, handle, added);
        }
    }

    public boolean member(NodeHandle nh) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].equals(nh)) continue;
            return true;
        }
        return false;
    }

    public boolean member(Id nid) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nid)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.theSize;
    }

    public void pingAllNew() {
        for (int i = 0; i < this.theSize; ++i) {
            if (this.nodes[i].proximity() != Integer.MAX_VALUE) continue;
            this.nodes[i].ping();
        }
    }

    public NodeHandle closestNode() {
        return this.closestNode(2);
    }

    public NodeHandle closestNode(int minLiveness) {
        int bestProximity = Integer.MAX_VALUE;
        NodeHandle bestNode = null;
        for (int i = 0; i < this.theSize; ++i) {
            int p;
            if (this.nodes[i].getLiveness() > minLiveness || (p = this.nodes[i].proximity()) > bestProximity) continue;
            bestProximity = p;
            bestNode = this.nodes[i];
            this.closest = i;
        }
        if (bestNode != null && bestProximity == Integer.MAX_VALUE) {
            bestNode.ping();
        }
        return bestNode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.nodes = (NodeHandle[])in.readObject();
        this.theSize = in.readInt();
        this.closest = in.readInt();
        if (this.closest != -1) {
            this.nodes[this.closest].ping();
        }
        this.closest = -1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.closest == -1) {
            this.closestNode();
        }
        NodeHandle[] tmp = new NodeHandle[this.nodes.length];
        int j = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].isAlive()) continue;
            tmp[j] = this.nodes[i];
            ++j;
        }
        out.writeObject(tmp);
        out.writeInt(j);
        int closest = -1;
        for (int i = 0; i < j; ++i) {
            if (closest != -1 && tmp[i].proximity() >= tmp[closest].proximity()) continue;
            closest = i;
        }
        out.writeInt(closest);
    }

    public boolean putHandle(rice.p2p.commonapi.NodeHandle handle) {
        return this.put((NodeHandle)handle);
    }

    public boolean memberHandle(rice.p2p.commonapi.Id id) {
        return this.member((Id)id);
    }

    public rice.p2p.commonapi.NodeHandle removeHandle(rice.p2p.commonapi.Id id) {
        return this.remove((Id)id);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)this.nodes.length);
        buf.writeByte((byte)this.theSize);
        buf.writeByte((byte)this.closest);
        for (int i = 0; i < this.theSize; ++i) {
            this.nodes[i].serialize(buf);
        }
    }
}

