/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.io.Serializable;
import java.util.Date;
import rice.pastry.Id;
import rice.pastry.NodeHandle;

public abstract class Message
implements Serializable,
rice.p2p.commonapi.Message {
    private int destination;
    private NodeHandle sender;
    private boolean priority;
    private byte priorityLevel = (byte)5;
    private transient Date theStamp;
    private static final long serialVersionUID = 8921944904321235696L;
    public static final int DEFAULT_PRIORITY_LEVEL = 5;

    public Message(int dest) {
        this(dest, null);
    }

    public Message(int dest, Date timestamp) {
        this.destination = dest;
        this.theStamp = timestamp;
        this.sender = null;
        this.priority = false;
    }

    public int getDestination() {
        return this.destination;
    }

    public Date getDate() {
        return this.theStamp;
    }

    public Id getSenderId() {
        if (this.sender == null) {
            return null;
        }
        return this.sender.getNodeId();
    }

    public NodeHandle getSender() {
        return this.sender;
    }

    public byte getPriority() {
        return this.priorityLevel;
    }

    public void setSender(NodeHandle nh) {
        this.sender = nh;
    }

    protected void setPriority(byte prio) {
        this.priorityLevel = prio;
    }

    public boolean stamp(Date time) {
        if (this.theStamp.equals(null)) {
            this.theStamp = time;
            return true;
        }
        return false;
    }
}

