/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.join;

import java.io.IOException;
import java.util.Date;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.join.JoinAddress;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteSet;

public class JoinRequest
extends PRawMessage {
    private NodeHandle handle;
    private NodeHandle joinHandle;
    private byte rowCount;
    private RouteSet[][] rows;
    private LeafSet leafSet;
    private byte rtBaseBitLength;
    public static final byte HAS_HANDLE = 1;
    public static final byte HAS_JOIN_HANDLE = 2;
    public static final byte HAS_LEAFSET = 2;
    static final long serialVersionUID = 231671018732832563L;
    public static final short TYPE = 1;

    public JoinRequest(NodeHandle nh, byte rtBaseBitLength) {
        this(nh, null, rtBaseBitLength);
    }

    public JoinRequest(NodeHandle nh, Date stamp, byte rtBaseBitLength) {
        super(JoinAddress.getCode(), stamp);
        this.handle = nh;
        this.initialize(rtBaseBitLength);
        this.setPriority((byte)0);
    }

    public JoinRequest(InputBuffer buf, NodeHandleFactory nhf, NodeHandle sender) throws IOException {
        super(JoinAddress.getCode());
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.setSender(sender);
                this.rtBaseBitLength = buf.readByte();
                this.initialize(this.rtBaseBitLength);
                this.handle = nhf.readNodeHandle(buf);
                if (buf.readBoolean()) {
                    this.joinHandle = nhf.readNodeHandle(buf);
                }
                this.rowCount = buf.readByte();
                int numRows = 160 / this.rtBaseBitLength;
                int numCols = 1 << this.rtBaseBitLength;
                for (int i = 0; i < numRows; ++i) {
                    RouteSet[] thisRow;
                    if (buf.readBoolean()) {
                        thisRow = new RouteSet[numCols];
                        for (int j = 0; j < numCols; ++j) {
                            thisRow[j] = buf.readBoolean() ? new RouteSet(buf, nhf) : null;
                        }
                    } else {
                        thisRow = null;
                    }
                    this.rows[i] = thisRow;
                }
                if (!buf.readBoolean()) break;
                this.leafSet = LeafSet.build(buf, nhf);
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public NodeHandle getHandle() {
        return this.handle;
    }

    public NodeHandle getJoinHandle() {
        return this.joinHandle;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RouteSet[] getRow(int i) {
        return this.rows[i];
    }

    public short getType() {
        return 1;
    }

    public boolean accepted() {
        return this.joinHandle != null;
    }

    public void acceptJoin(NodeHandle nh, LeafSet ls) {
        this.joinHandle = nh;
        this.leafSet = ls;
    }

    public int lastRow() {
        return this.rowCount;
    }

    public void pushRow(RouteSet[] row) {
        this.rowCount = (byte)(this.rowCount - 1);
        this.rows[this.rowCount] = row;
    }

    public int numRows() {
        return this.rows.length;
    }

    private void initialize(byte rtBaseBitLength) {
        this.joinHandle = null;
        this.rtBaseBitLength = rtBaseBitLength;
        this.rowCount = (byte)(160 / rtBaseBitLength);
        this.rows = new RouteSet[this.rowCount][];
    }

    public String toString() {
        return "JoinRequest(" + (this.handle != null ? this.handle.getNodeId() : null) + "," + (this.joinHandle != null ? this.joinHandle.getNodeId() : null) + ")";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeByte(this.rtBaseBitLength);
        this.handle.serialize(buf);
        if (this.joinHandle != null) {
            buf.writeBoolean(true);
            this.joinHandle.serialize(buf);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte(this.rowCount);
        int maxIndex = 160 / this.rtBaseBitLength;
        for (int i = 0; i < maxIndex; ++i) {
            RouteSet[] thisRow = this.rows[i];
            if (thisRow != null) {
                buf.writeBoolean(true);
                for (int j = 0; j < thisRow.length; ++j) {
                    if (thisRow[j] != null) {
                        buf.writeBoolean(true);
                        thisRow[j].serialize(buf);
                        continue;
                    }
                    buf.writeBoolean(false);
                }
                continue;
            }
            buf.writeBoolean(false);
        }
        if (this.leafSet != null) {
            buf.writeBoolean(true);
            this.leafSet.serialize(buf);
        } else {
            buf.writeBoolean(false);
        }
    }
}

