/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.environment.Environment;
import rice.pastry.direct.BasicNetworkSimulator;
import rice.pastry.direct.NodeRecord;

public class SphereNetwork
extends BasicNetworkSimulator {
    public SphereNetwork(Environment env) {
        super(env);
    }

    public NodeRecord generateNodeRecord() {
        return new SphereNodeRecord();
    }

    public void test() {
        System.out.println(new SphereNodeRecord(0.0, 0.0).proximity(new SphereNodeRecord(0.0, Math.PI)));
        System.out.println(new SphereNodeRecord(-1.0, 0.0).proximity(new SphereNodeRecord(1.0, Math.PI)));
        for (int i = 0; i < 100; ++i) {
            System.out.println(new SphereNodeRecord().proximity(new SphereNodeRecord()));
        }
    }

    public static void main(String[] argz) {
        System.out.println("hello world");
        new SphereNetwork(Environment.directEnvironment()).test();
    }

    private class SphereNodeRecord
    implements NodeRecord {
        public double theta;
        public double phi;
        double radius;

        public SphereNodeRecord() {
            this(Math.asin(2.0 * this$0.random.nextDouble() - 1.0), Math.PI * 2 * this$0.random.nextDouble());
        }

        public SphereNodeRecord(double theta, double phi) {
            this.theta = theta;
            this.phi = phi;
            this.radius = (double)SphereNetwork.this.maxDiameter / Math.PI;
        }

        public int proximity(NodeRecord that) {
            SphereNodeRecord nr = (SphereNodeRecord)that;
            int ret = (int)(this.radius * Math.acos(Math.cos(this.phi - nr.phi) * Math.cos(this.theta) * Math.cos(nr.theta) + Math.sin(this.theta) * Math.sin(nr.theta)));
            if (ret < 2 && !this.equals(that)) {
                return 2;
            }
            return ret;
        }
    }
}

