/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.Hashtable;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.ConsistentJoinProtocol;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;

public class DirectPastryNodeFactory
extends PastryNodeFactory {
    private NodeIdFactory nidFactory;
    private NetworkSimulator simulator;
    Hashtable recordTable = new Hashtable();

    public DirectPastryNodeFactory(NodeIdFactory nf, NetworkSimulator sim, Environment env) {
        super(env);
        env.getParameters().setInt("pastry_protocol_consistentJoin_max_time_to_be_scheduled", 120000);
        this.nidFactory = nf;
        this.simulator = sim;
    }

    public NetworkSimulator getNetworkSimulator() {
        return this.simulator;
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getLeafSet();
    }

    public CancellableTask getLeafSet(NodeHandle handle, Continuation c) {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        c.receiveResult(dHandle.getRemote().getLeafSet());
        return new NullCancellableTask();
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getRoutingTable().getRow(row);
    }

    public CancellableTask getRouteRow(NodeHandle handle, int row, Continuation c) {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        c.receiveResult(dHandle.getRemote().getRoutingTable().getRow(row));
        return new NullCancellableTask();
    }

    public int getProximity(NodeHandle local, NodeHandle remote) {
        return this.simulator.proximity((DirectNodeHandle)local, (DirectNodeHandle)remote);
    }

    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, Id nodeId) {
        NodeRecord nr;
        if (bootstrap == null && this.logger.level <= 900) {
            this.logger.log("No bootstrap node provided, starting a new ring...");
        }
        Environment environment = this.environment;
        if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes") && this.environment.getLogManager() instanceof CloneableLogManager) {
            environment = new Environment(this.environment.getSelectorManager(), this.environment.getProcessor(), this.environment.getRandomSource(), this.environment.getTimeSource(), ((CloneableLogManager)this.environment.getLogManager()).clone("0x" + nodeId.toStringBare()), this.environment.getParameters());
        }
        if ((nr = (NodeRecord)this.recordTable.get(nodeId)) == null) {
            nr = this.simulator.generateNodeRecord();
            this.recordTable.put(nodeId, nr);
        }
        DirectPastryNode pn = new DirectPastryNode(nodeId, this.simulator, environment, nr);
        DirectNodeHandle localhandle = new DirectNodeHandle(pn, pn, this.simulator);
        this.simulator.registerNode(pn);
        MessageDispatch msgDisp = new MessageDispatch(pn);
        RoutingTable routeTable = new RoutingTable(localhandle, this.rtMax, this.rtBase, environment);
        LeafSet leafSet = new LeafSet(localhandle, this.lSetSize);
        StandardRouter router = new StandardRouter(pn);
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol(pn, routeTable, environment);
        pn.setElements(localhandle, msgDisp, leafSet, routeTable);
        router.register();
        rsProtocol.register();
        PeriodicLeafSetProtocol lsProtocol = new PeriodicLeafSetProtocol((PastryNode)pn, localhandle, leafSet, routeTable);
        lsProtocol.register();
        ConsistentJoinProtocol jProtocol = new ConsistentJoinProtocol((PastryNode)pn, (NodeHandle)localhandle, routeTable, leafSet, lsProtocol);
        jProtocol.register();
        pn.doneNode(this.getNearest(localhandle, bootstrap));
        return pn;
    }

    protected int proximity(NodeHandle local, NodeHandle handle) {
        return this.getProximity(local, handle);
    }

    class NullCancellableTask
    implements CancellableTask {
        NullCancellableTask() {
        }

        public void run() {
        }

        public boolean cancel() {
            return false;
        }

        public long scheduledExecutionTime() {
            return 0L;
        }
    }
}

