/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;

public class DirectNodeHandle
extends NodeHandle
implements Observer {
    private DirectPastryNode remoteNode;
    public NetworkSimulator simulator;
    protected Logger logger;

    DirectNodeHandle(DirectPastryNode ln, DirectPastryNode rn, NetworkSimulator sim) {
        this.localnode = ln;
        this.logger = ln.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        if (rn == null) {
            throw new IllegalArgumentException("rn must be non-null");
        }
        this.remoteNode = rn;
        this.simulator = sim;
        rn.addObserver(this);
    }

    public DirectPastryNode getRemote() {
        return this.remoteNode;
    }

    public Id getNodeId() {
        return this.remoteNode.getNodeId();
    }

    public int getLiveness() {
        if (this.remoteNode.isAlive()) {
            return 1;
        }
        return 3;
    }

    public NetworkSimulator getSimulator() {
        return this.simulator;
    }

    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public boolean ping() {
        return this.isAlive();
    }

    public final void assertLocalNode() {
        if (DirectPastryNode.getCurrentNode() == null) {
            throw new RuntimeException("PANIC: localnode is null in " + this + "@" + System.identityHashCode(this));
        }
    }

    public int proximity() {
        this.assertLocalNode();
        int result = this.simulator.proximity((DirectNodeHandle)DirectPastryNode.getCurrentNode().getLocalHandle(), this);
        return result;
    }

    public void receiveMessage(Message msg) {
        if (this.remoteNode == DirectPastryNode.getCurrentNode()) {
            this.remoteNode.receiveMessage(msg);
            return;
        }
        if (!this.remoteNode.isAlive()) {
            if (this.logger.level <= 900) {
                this.logger.log("DirectNodeHandle: attempt to send message " + msg + " to a dead node " + this.getNodeId() + "!");
            }
        } else {
            this.simulator.deliverMessage(msg, this.remoteNode, this.proximity());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DirectNodeHandle nh = (DirectNodeHandle)obj;
        return this.remoteNode.getNodeId().equals(nh.remoteNode.getNodeId());
    }

    public int hashCode() {
        return this.getNodeId().hashCode();
    }

    public String toString() {
        return "[DNH " + this.getNodeId() + "]";
    }

    public void update(Observable arg0, Object arg1) {
        if (this.remoteNode.alive) {
            this.notifyObservers(NodeHandle.DECLARED_LIVE);
        } else {
            this.notifyObservers(NodeHandle.DECLARED_DEAD);
        }
    }

    public void serialize(OutputBuffer buf) throws IOException {
        throw new RuntimeException("Should not be called.");
    }
}

