/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.Id;
import rice.pastry.ScheduledMessage;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DeliveryTimerTask;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectTimerTask;
import rice.pastry.direct.MessageDelivery;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.TestRecord;
import rice.pastry.messaging.Message;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public abstract class BasicNetworkSimulator
implements NetworkSimulator {
    Vector nodes = new Vector();
    protected TreeSet taskQueue = new TreeSet();
    Environment environment;
    DirectTimeSource timeSource;
    private TestRecord testRecord;
    protected Logger logger;
    protected RandomSource random;
    protected int MIN_DELAY = 1;
    protected SelectorManager manager;
    protected final int maxDiameter;
    protected final int minDelay;
    boolean running = false;

    public BasicNetworkSimulator(Environment env) {
        this.environment = env;
        this.manager = this.environment.getSelectorManager();
        Parameters params = env.getParameters();
        this.maxDiameter = params.getInt("pastry_direct_max_diameter");
        this.minDelay = params.getInt("pastry_direct_min_delay");
        this.random = params.contains("pastry_direct_use_own_random") && params.getBoolean("pastry_direct_use_own_random") ? (params.contains("pastry_direct_random_seed") && !params.getString("pastry_direct_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_direct_random_seed"), env.getLogManager(), "direct") : new SimpleRandomSource(env.getLogManager(), "direct")) : env.getRandomSource();
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
        try {
            this.timeSource = (DirectTimeSource)env.getTimeSource();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("env.getTimeSource() must return a DirectTimeSource instead of a " + env.getTimeSource().getClass().getName());
        }
        this.testRecord = null;
        this.start();
    }

    public TestRecord getTestRecord() {
        return this.testRecord;
    }

    public boolean isAlive(DirectNodeHandle nh) {
        return nh.getRemote().isAlive();
    }

    public DirectNodeHandle getClosest(DirectNodeHandle nh) {
        Iterator it = this.nodes.iterator();
        DirectNodeHandle bestHandle = null;
        int bestProx = Integer.MAX_VALUE;
        while (it.hasNext()) {
            DirectPastryNode theNode = (DirectPastryNode)it.next();
            int theProx = theNode.record.proximity(nh.getRemote().record);
            Id theId = theNode.getNodeId();
            if (!theNode.isAlive() || !theNode.isReady() || theId.equals(nh.getNodeId()) || theProx >= bestProx) continue;
            bestProx = theProx;
            bestHandle = (DirectNodeHandle)theNode.getLocalHandle();
        }
        return bestHandle;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setTestRecord(TestRecord tr) {
        this.testRecord = tr;
    }

    public void start() {
        this.manager.invoke(new Runnable(){

            public void run() {
                if (BasicNetworkSimulator.this.running) {
                    return;
                }
                BasicNetworkSimulator.this.running = true;
                BasicNetworkSimulator.this.manager.invoke(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!1.access$000(this.this$1).running) {
                            return;
                        }
                        if (!BasicNetworkSimulator.access$100(1.access$000(this.this$1))) {
                            Selector sel;
                            Selector selector = sel = 1.access$000(this.this$1).manager.getSelector();
                            synchronized (selector) {
                                try {
                                    sel.wait(100L);
                                }
                                catch (InterruptedException ie) {
                                    1.access$000(this.this$1).logger.logException("BasicNetworkSimulator interrupted.", ie);
                                }
                            }
                        }
                        1.access$000(this.this$1).manager.invoke(this);
                    }
                });
            }

            static /* synthetic */ BasicNetworkSimulator access$000(1 x0) {
                return x0.BasicNetworkSimulator.this;
            }
        });
    }

    public void stop() {
        this.manager.invoke(new Runnable(){

            public void run() {
                BasicNetworkSimulator.this.running = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(TimerTask dtt) {
        if (this.logger.level <= 500) {
            this.logger.log("addTask(" + dtt + ")");
        }
        TreeSet treeSet = this.taskQueue;
        synchronized (treeSet) {
            this.taskQueue.add(dtt);
        }
    }

    public CancellableTask enqueueDelivery(Delivery d, int delay) {
        long time = this.timeSource.currentTimeMillis() + (long)delay;
        if (this.logger.level <= 500) {
            this.logger.log("GNS: enqueueDelivery " + d + ":" + time);
        }
        DeliveryTimerTask dtt = null;
        dtt = new DeliveryTimerTask(d, time, d.getSeq());
        this.addTask(dtt);
        return dtt;
    }

    public ScheduledMessage deliverMessage(Message msg, DirectPastryNode node) {
        if (this.logger.level <= 500) {
            this.logger.log("GNS: deliver " + msg + " to " + node);
        }
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        DirectPastryNode senderNode = DirectPastryNode.getCurrentNode();
        if (senderNode != null) {
            sender = (DirectNodeHandle)senderNode.getLocalNodeHandle();
        }
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis());
            this.addTask(dtt);
        }
        return dtt;
    }

    public ScheduledMessage deliverMessage(Message msg, DirectPastryNode node, int delay) {
        if (this.logger.level <= 500) {
            this.logger.log("GNS: deliver(" + delay + ") " + msg + " to " + node);
        }
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        DirectPastryNode senderNode = DirectPastryNode.getCurrentNode();
        if (senderNode != null) {
            sender = (DirectNodeHandle)senderNode.getLocalNodeHandle();
        }
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay);
            this.addTask(dtt);
        }
        return dtt;
    }

    public ScheduledMessage deliverMessage(Message msg, DirectPastryNode node, int delay, int period) {
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        DirectPastryNode senderNode = DirectPastryNode.getCurrentNode();
        if (senderNode != null) {
            sender = (DirectNodeHandle)senderNode.getLocalNodeHandle();
        }
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay, period);
            this.addTask(dtt);
        }
        return dtt;
    }

    public ScheduledMessage deliverMessageFixedRate(Message msg, DirectPastryNode node, int delay, int period) {
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        DirectPastryNode senderNode = DirectPastryNode.getCurrentNode();
        if (senderNode != null) {
            sender = (DirectNodeHandle)senderNode.getLocalNodeHandle();
        }
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay, period, true);
            this.addTask(dtt);
        }
        return dtt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean simulate() {
        TimerTask task;
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new RuntimeException("Must be on selector thread");
        }
        TreeSet treeSet = this.taskQueue;
        synchronized (treeSet) {
            if (this.taskQueue.isEmpty()) {
                if (this.logger.level <= 500) {
                    this.logger.log("taskQueue is empty");
                }
                return false;
            }
            task = (TimerTask)this.taskQueue.first();
            if (this.logger.level <= 500) {
                this.logger.log("simulate():" + task);
            }
            this.taskQueue.remove(task);
        }
        if (task.scheduledExecutionTime() > this.timeSource.currentTimeMillis()) {
            if (this.logger.level <= 400) {
                this.logger.log("the time is now " + task.scheduledExecutionTime());
            }
            this.timeSource.setTime(task.scheduledExecutionTime());
        }
        if (task.execute(this.timeSource)) {
            this.addTask(task);
        }
        return true;
    }

    public void destroy(DirectPastryNode node) {
        node.destroy();
    }

    public int proximity(DirectNodeHandle a, DirectNodeHandle b) {
        NodeRecord nra = a.getRemote().record;
        NodeRecord nrb = b.getRemote().record;
        if (nra == null || nrb == null) {
            throw new Error("asking about node proximity for unknown node(s)");
        }
        return nra.proximity(nrb);
    }

    public void registerNode(DirectPastryNode dpn) {
        this.nodes.add(dpn);
    }

    public void removeNode(DirectPastryNode node) {
        this.nodes.remove(node);
    }

    static /* synthetic */ boolean access$100(BasicNetworkSimulator x0) {
        return x0.simulate();
    }
}

