/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.io.IOException;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.JavaSerializedMessage;
import rice.pastry.NodeHandle;
import rice.pastry.messaging.PRawMessage;

public class PastryEndpointMessage
extends PRawMessage {
    protected RawMessage message;
    public static final short TYPE = 2;
    private static final long serialVersionUID = 4499456388556140871L;

    public PastryEndpointMessage(int address, Message message, NodeHandle sender) {
        this(address, message instanceof RawMessage ? (RawMessage)message : new JavaSerializedMessage(message), sender);
    }

    public PastryEndpointMessage(int address, RawMessage message, NodeHandle sender) {
        super(address);
        this.setSender(sender);
        this.message = message;
        this.setPriority(message.getPriority());
    }

    public PastryEndpointMessage(int address, InputBuffer buf, MessageDeserializer md, NodeHandle sender) throws IOException {
        super(address);
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.setSender(sender);
                byte priority = buf.readByte();
                short type = buf.readShort();
                this.message = type == 0 ? new JavaSerializedMessage(md.deserialize(buf, type, priority, sender)) : (RawMessage)md.deserialize(buf, type, priority, sender);
                if (this.getMessage() != null) break;
                throw new IOException("PEM.deserialize() message = null type:" + type + " md:" + md);
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public Message getMessage() {
        if (this.message.getType() == 0) {
            return ((JavaSerializedMessage)this.message).getMessage();
        }
        return this.message;
    }

    public short getType() {
        return 2;
    }

    public void setMessage(Message message) {
        if (message instanceof RawMessage) {
            this.setMessage((RawMessage)message);
        } else {
            this.message = new JavaSerializedMessage(message);
        }
    }

    public void setMessage(RawMessage message) {
        this.message = message;
    }

    public String toString() {
        return "[PEM " + this.getMessage() + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeByte(this.message.getPriority());
        buf.writeShort(this.message.getType());
        this.message.serialize(buf);
    }
}

