/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.io.IOException;
import java.security.InvalidParameterException;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.SendOptions;

public class PastryEndpoint
extends PastryAppl
implements Endpoint {
    protected Application application;
    protected String instance;
    MessageDeserializer appDeserializer;

    public PastryEndpoint(PastryNode pn, Application application, String instance, boolean register) {
        this(pn, application, instance, 0, register);
    }

    public PastryEndpoint(PastryNode pn, Application application, String instance, int address, boolean register) {
        super(pn, application.getClass().getName() + instance, address, null);
        this.appDeserializer = this.deserializer;
        this.deserializer = new PEDeserializer();
        this.application = application;
        if (register) {
            this.register();
        }
    }

    public rice.p2p.commonapi.Id getId() {
        return this.thePastryNode.getNodeId();
    }

    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public String getInstance() {
        return this.instance;
    }

    public Environment getEnvironment() {
        return this.thePastryNode.getEnvironment();
    }

    public MessageDeserializer getDeserializer() {
        return this.appDeserializer;
    }

    public void setDeserializer(MessageDeserializer md) {
        this.appDeserializer = md;
    }

    public void route(rice.p2p.commonapi.Id key, rice.p2p.commonapi.Message msg, rice.p2p.commonapi.NodeHandle hint) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] route " + msg + " to " + key);
        }
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        if (key == null && hint == null) {
            throw new InvalidParameterException("key and hint are null!");
        }
        boolean noKey = false;
        if (key == null) {
            noKey = true;
            key = hint.getId();
        }
        rice.pastry.routing.RouteMessage rm = new rice.pastry.routing.RouteMessage((Id)key, (Message)pm, (NodeHandle)hint);
        if (noKey) {
            rm.getOptions().setMultipleHopsAllowed(false);
        }
        this.thePastryNode.receiveMessage(rm);
    }

    public void route(rice.p2p.commonapi.Id key, RawMessage msg, rice.p2p.commonapi.NodeHandle hint) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] route " + msg + " to " + key);
        }
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        if (key == null && hint == null) {
            throw new InvalidParameterException("key and hint are null!");
        }
        boolean noKey = false;
        if (key == null) {
            noKey = true;
            key = hint.getId();
        }
        rice.pastry.routing.RouteMessage rm = new rice.pastry.routing.RouteMessage((Id)key, (Message)pm, (NodeHandle)hint);
        if (noKey) {
            rm.getOptions().setMultipleHopsAllowed(false);
        }
        this.thePastryNode.receiveMessage(rm);
    }

    public CancellableTask scheduleMessage(rice.p2p.commonapi.Message message, long delay) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), message, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsg(pm, delay);
    }

    public CancellableTask scheduleMessage(rice.p2p.commonapi.Message message, long delay, long period) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), message, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsg(pm, delay, period);
    }

    public CancellableTask scheduleMessageAtFixedRate(rice.p2p.commonapi.Message msg, long delay, long period) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsgAtFixedRate(pm, delay, period);
    }

    public NodeHandleSet localLookup(rice.p2p.commonapi.Id key, int num, boolean safe) {
        return this.getRoutingTable().alternateRoutes((Id)key, num);
    }

    public NodeHandleSet neighborSet(int num) {
        return this.getLeafSet().neighborSet(num);
    }

    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int maxRank) {
        LeafSet leafset = this.getLeafSet();
        if (maxRank > leafset.maxSize() / 2 + 1) {
            throw new IllegalArgumentException("maximum replicaSet size for this configuration exceeded; asked for " + maxRank + " but max is " + leafset.maxSize() / 2 + 1);
        }
        if (maxRank > leafset.size() && this.logger.level <= 400) {
            this.logger.log("trying to get a replica set of size " + maxRank + " but only " + leafset.size() + " nodes in leafset");
        }
        return leafset.replicaSet((Id)id, maxRank);
    }

    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int maxRank, rice.p2p.commonapi.NodeHandle root, NodeHandleSet set) {
        LeafSet leaf = new LeafSet((NodeHandle)root, this.getLeafSet().maxSize(), false);
        for (int i = 0; i < set.size(); ++i) {
            leaf.put((NodeHandle)set.getHandle(i));
        }
        return leaf.replicaSet((Id)id, maxRank);
    }

    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle n, int r, rice.p2p.commonapi.Id key, boolean cumulative) {
        Id pKey = (Id)key;
        if (cumulative) {
            return this.getLeafSet().range((NodeHandle)n, r);
        }
        IdRange ccw = this.getLeafSet().range((NodeHandle)n, r, false);
        IdRange cw = this.getLeafSet().range((NodeHandle)n, r, true);
        if (cw == null || ccw.contains(pKey) || pKey.isBetween(cw.getCW(), ccw.getCCW())) {
            return ccw;
        }
        return cw;
    }

    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle n, int r, rice.p2p.commonapi.Id key) {
        return this.range(n, r, key, false);
    }

    public final void messageForAppl(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] deliver " + msg + " from " + msg.getSenderId());
        }
        if (msg instanceof PastryEndpointMessage) {
            this.application.deliver(null, ((PastryEndpointMessage)msg).getMessage());
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unknown message " + msg + " - dropping on floor");
        }
    }

    public final boolean enrouteMessage(rice.p2p.commonapi.Message msg, rice.p2p.commonapi.Id key, rice.p2p.commonapi.NodeHandle nextHop, SendOptions opt) {
        if (msg instanceof RouteMessage) {
            if (this.logger.level <= 400) {
                this.logger.log("[" + this.thePastryNode + "] forward " + msg);
            }
            return this.application.forward((RouteMessage)((Object)msg));
        }
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        this.application.update(nh, wasAdded);
    }

    public void receiveMessage(Message msg) {
        block8: {
            if (this.logger.level <= 400) {
                this.logger.log("[" + this.thePastryNode + "] recv " + msg);
            }
            if (msg instanceof rice.pastry.routing.RouteMessage) {
                try {
                    rice.pastry.routing.RouteMessage rm = (rice.pastry.routing.RouteMessage)msg;
                    if (this.logger.level <= 400) {
                        this.logger.log("[" + this.thePastryNode + "] forward " + msg);
                    }
                    if (!this.application.forward(rm) || rm.nextHop == null) break block8;
                    NodeHandle nextHop = rm.nextHop;
                    if (this.getNodeId().equals(nextHop.getNodeId())) {
                        PastryEndpointMessage pMsg = (PastryEndpointMessage)rm.unwrap(this.deserializer);
                        if (this.logger.level <= 400) {
                            this.logger.log("[" + this.thePastryNode + "] deliver " + pMsg + " from " + pMsg.getSenderId());
                        }
                        this.application.deliver(rm.getTarget(), pMsg.getMessage());
                        break block8;
                    }
                    rm.routeMessage((NodeHandle)this.getLocalNodeHandle());
                }
                catch (IOException ioe) {
                    if (this.logger.level <= 1000) {
                        this.logger.logException(this.toString(), ioe);
                    }
                    break block8;
                }
            }
            this.messageForAppl(msg);
        }
    }

    public void process(Executable task, Continuation command) {
        this.thePastryNode.process(task, command);
    }

    public void connect(rice.p2p.commonapi.NodeHandle handle, AppSocketReceiver receiver, int timeout) {
        this.connect((NodeHandle)handle, receiver, timeout);
    }

    public String toString() {
        return "PastryEndpoint " + this.application + " " + this.instance + " " + this.getAddress();
    }

    public rice.p2p.commonapi.Id readId(InputBuffer buf, short type) throws IOException {
        if (type != 1) {
            throw new IllegalArgumentException("Invalid type:" + type);
        }
        return Id.build(buf);
    }

    public rice.p2p.commonapi.NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.thePastryNode.readNodeHandle(buf);
    }

    public rice.p2p.commonapi.IdRange readIdRange(InputBuffer buf) throws IOException {
        return new IdRange(buf);
    }

    public rice.p2p.commonapi.NodeHandle coalesce(rice.p2p.commonapi.NodeHandle newHandle) {
        return this.thePastryNode.coalesce((NodeHandle)newHandle);
    }

    public NodeHandleSet readNodeHandleSet(InputBuffer buf, short type) throws IOException {
        switch (type) {
            case 1: {
                return new NodeSet(buf, this.thePastryNode);
            }
            case 2: {
                return new RouteSet(buf, this.thePastryNode);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    class PEDeserializer
    implements MessageDeserializer {
        PEDeserializer() {
        }

        public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, byte priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
            if (type == 2) {
                return new PastryEndpointMessage(PastryEndpoint.this.getAddress(), buf, PastryEndpoint.this.appDeserializer, (NodeHandle)sender);
            }
            return null;
        }
    }
}

