/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeSetI;

public class NodeSet
implements NodeSetI,
Serializable {
    private Vector set;
    public static final short TYPE = 1;
    static final long serialVersionUID = 4410658508346287677L;

    public NodeSet() {
        this.set = new Vector();
    }

    public NodeSet(Vector s) {
        this.set = s;
    }

    public NodeSet(NodeSet o) {
        this.set = new Vector(o.set);
    }

    public NodeSet(InputBuffer buf, NodeHandleFactory nhf) throws IOException {
        int numNodes = buf.readShort();
        this.set = new Vector(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            this.set.add(nhf.readNodeHandle(buf));
        }
    }

    public NodeHandle get(Id nid) {
        try {
            return (NodeHandle)this.set.elementAt(this.getIndex(nid));
        }
        catch (Exception e) {
            return null;
        }
    }

    public NodeHandle get(int i) {
        NodeHandle h;
        try {
            h = (NodeHandle)this.set.elementAt(i);
        }
        catch (Exception e) {
            return null;
        }
        return h;
    }

    public int getIndex(Id nid) {
        return this.getIndexId(nid);
    }

    public int getIndex(NodeHandle nh) {
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                NodeHandle h = (NodeHandle)this.set.elementAt(i);
                if (!h.equals(nh)) continue;
                return i;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getIndexId(rice.p2p.commonapi.Id nid) {
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                NodeHandle h = (NodeHandle)this.set.elementAt(i);
                if (!h.getNodeId().equals(nid)) continue;
                return i;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public Iterator getIterator() {
        return this.set.iterator();
    }

    public rice.p2p.commonapi.NodeHandle getHandle(rice.p2p.commonapi.Id id) {
        return this.getHandle(id);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(int i) {
        return this.get(i);
    }

    public int getIndexHandle(rice.p2p.commonapi.Id id) throws NoSuchElementException {
        return this.getIndex((Id)id);
    }

    public short getType() {
        return 1;
    }

    public boolean put(NodeHandle handle) {
        if (this.set.contains(handle)) {
            return false;
        }
        this.set.add(handle);
        return true;
    }

    public void randomize(RandomSource random) {
        for (int i = 0; i < this.set.size(); ++i) {
            int a = random.nextInt(this.set.size());
            int b = random.nextInt(this.set.size());
            Object tmp = this.set.elementAt(a);
            this.set.setElementAt(this.set.elementAt(b), a);
            this.set.setElementAt(tmp, b);
        }
    }

    private boolean memberId(rice.p2p.commonapi.Id id) {
        return this.getIndexId(id) >= 0;
    }

    public NodeHandle remove(Id nid) {
        try {
            return (NodeHandle)this.set.remove(this.getIndex(nid));
        }
        catch (Exception e) {
            return null;
        }
    }

    public int size() {
        return this.set.size();
    }

    public boolean insert(int index, NodeHandle handle) {
        if (this.set.contains(handle)) {
            return false;
        }
        this.set.add(index, handle);
        return true;
    }

    public NodeHandle remove(NodeHandle handle) {
        if (this.set.remove(handle)) {
            return handle;
        }
        return null;
    }

    public void remove(int index) {
        this.set.remove(index);
    }

    public int indexOf(NodeHandle handle) {
        return this.set.indexOf(handle);
    }

    public boolean member(NodeHandle handle) {
        return this.set.contains(handle);
    }

    NodeSet subSet(int from, int to) {
        NodeSet res;
        try {
            res = new NodeSet(new Vector(this.set.subList(from, to)));
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    public String toString() {
        String s = "NodeSet: ";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.get(i).getNodeId();
        }
        return s;
    }

    public boolean putHandle(rice.p2p.commonapi.NodeHandle handle) {
        return this.put((NodeHandle)handle);
    }

    public boolean memberHandle(rice.p2p.commonapi.Id id) {
        return this.memberId(id);
    }

    public rice.p2p.commonapi.NodeHandle removeHandle(rice.p2p.commonapi.Id id) {
        return this.remove((Id)id);
    }

    public Iterator iterator() {
        return this.set.iterator();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort((short)this.set.size());
        Iterator i = this.set.iterator();
        while (i.hasNext()) {
            NodeHandle nh = (NodeHandle)i.next();
            nh.serialize(buf);
        }
    }
}

