/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.messaging.Message;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class ExponentialBackoffScheduledMessage
extends ScheduledMessage {
    boolean cancelled = false;
    EBTimerTask myTask;
    Timer timer;
    long initialPeriod;
    double expBase;
    int numTimes = 0;
    long lastTime = 0L;

    public ExponentialBackoffScheduledMessage(PastryNode node, Message msg, Timer timer, long delay, long initialPeriod, double expBase) {
        super(node, msg);
        this.timer = timer;
        this.initialPeriod = initialPeriod;
        this.expBase = expBase;
        this.schedule(delay);
    }

    public ExponentialBackoffScheduledMessage(PastryNode node, Message msg, Timer timer, long initialDelay, double expBase) {
        super(node, msg);
        this.timer = timer;
        this.initialPeriod = initialDelay;
        this.expBase = expBase;
        this.schedule(initialDelay);
        this.numTimes = 1;
    }

    private void schedule(long time) {
        this.myTask = new EBTimerTask();
        this.timer.schedule(this.myTask, time);
    }

    public boolean cancel() {
        super.cancel();
        if (this.myTask != null) {
            this.myTask.cancel();
            this.myTask = null;
        }
        boolean temp = this.cancelled;
        this.cancelled = true;
        return temp;
    }

    public void run() {
        if (!this.cancelled) {
            if (this.myTask != null) {
                this.lastTime = this.myTask.scheduledExecutionTime();
            }
            super.run();
            long time = (long)((double)this.initialPeriod * Math.pow(this.expBase, this.numTimes));
            this.schedule(time);
            ++this.numTimes;
        }
    }

    public long scheduledExecutionTime() {
        return this.lastTime;
    }

    class EBTimerTask
    extends TimerTask {
        EBTimerTask() {
        }

        public void run() {
            ExponentialBackoffScheduledMessage.this.run();
        }
    }
}

