/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import java.io.IOException;
import java.util.Iterator;
import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdSet;
import rice.p2p.multiring.MultiringIdFactory;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdFactory;
import rice.p2p.util.IdBloomFilter;
import rice.pastry.commonapi.PastryIdFactory;

public class IdBloomFilterUnit {
    public static void main(String[] args) throws IOException {
        int n = Integer.parseInt(args[0]);
        Environment env = new Environment();
        RandomSource random = env.getRandomSource();
        PastryIdFactory pFactory = new PastryIdFactory(env);
        MultiringIdFactory factory = new MultiringIdFactory(pFactory.buildRandomId(random), pFactory);
        GCIdFactory gFactory = new GCIdFactory(factory);
        IdSet set = gFactory.buildIdSet();
        for (int i = 0; i < n; ++i) {
            set.addId(new GCId(factory.buildRandomId(random), System.currentTimeMillis()));
        }
        System.out.println("Start: " + System.currentTimeMillis());
        IdBloomFilter filter = new IdBloomFilter(set);
        System.out.println("Done1: " + System.currentTimeMillis());
        Iterator i = set.getIterator();
        while (i.hasNext()) {
            if (filter.check((Id)i.next())) continue;
            System.out.println("FAILURE: Element did not exist!");
        }
        System.out.println("Done2: " + System.currentTimeMillis());
        int count = 0;
        for (int j = 0; j < set.numElements(); ++j) {
            if (!filter.check(new GCId(factory.buildRandomId(random), System.currentTimeMillis()))) continue;
            ++count;
        }
        System.out.println("Done3: " + System.currentTimeMillis());
        System.out.println("FALSE POSITIVE RATE: " + count + "/" + set.numElements());
    }
}

