/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import rice.p2p.util.StringCache;

public class XMLParser
implements XmlPullParser {
    protected Reader reader;
    protected char[] buffer;
    protected int bufferPosition = 0;
    protected int bufferLimit = 0;
    protected StringCache cache;
    protected Stack tags;
    protected String name;
    protected String text;
    protected String[] attributeKeys = new String[100];
    protected String[] attributeValues = new String[100];
    protected int numAttributes = 0;
    protected boolean inTag = false;
    protected int mark = -1;
    protected CharArrayBuffer marked;
    public static final int BUFFER_SIZE = 32000;
    public static final int MAX_ATTRIBUTES = 100;
    public static final char[] QUOTE = new char[]{'\'', '\"'};
    public static final char[] TAG_END = new char[]{'>', '/', '?'};
    public static final char[] WHITESPACE = new char[]{' ', '\t', '\n', '\r'};
    public static final char[] WHITESPACE_OR_TAG_END = new char[]{' ', '\t', '\n', '\r', '>', '/', '?'};
    public static final char[] WHITESPACE_OR_EQUALS = new char[]{' ', '\t', '\n', '\r', '='};
    public static final char[] SINGLE = new char[1];
    public static final String[][] ENTITIES = new String[][]{{"&apos;", "'"}, {"&quot;", "\""}, {"&lt;", "<"}, {"&gt;", ">"}, {"&#13;", String.valueOf('\r')}, {"&#10;", String.valueOf('\n')}, {"&#9;", String.valueOf('\t')}, {"&amp;", "&"}};

    public XMLParser() {
        this.buffer = new char[32000];
        this.tags = new Stack();
        this.cache = new StringCache();
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public String getAttributeValue(String namespace, String name) {
        for (int i = 0; i < this.numAttributes; ++i) {
            if (!this.attributeKeys[i].equals(name)) continue;
            return this.attributeValues[i];
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return 0;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return this.isWhitespace(this.text);
    }

    public boolean isWhitespace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (this.contains(WHITESPACE, text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean getFeature(String name) {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException();
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public String getNamespace(String prefix) {
        throw new UnsupportedOperationException();
    }

    public int getDepth() {
        throw new UnsupportedOperationException();
    }

    public String getPositionDescription() {
        throw new UnsupportedOperationException();
    }

    public int getLineNumber() {
        throw new UnsupportedOperationException();
    }

    public int getColumnNumber() {
        throw new UnsupportedOperationException();
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        throw new UnsupportedOperationException();
    }

    public String getNamespace() {
        throw new UnsupportedOperationException();
    }

    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public String getAttributeNamespace(int index) {
        throw new UnsupportedOperationException();
    }

    public String getAttributePrefix(int index) {
        throw new UnsupportedOperationException();
    }

    public String getAttributeType(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean isAttributeDefault(int index) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    public String getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    public String getAttributeValue(int index) {
        throw new UnsupportedOperationException();
    }

    public void setInput(Reader in) throws XmlPullParserException {
        this.reader = in;
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public int next() throws XmlPullParserException, IOException {
        char next = '\u0000';
        try {
            next = this.current();
        }
        catch (EOFException e) {
            return 1;
        }
        switch (next) {
            case '<': {
                int result = this.parseTag();
                if (result == 0) {
                    return this.next();
                }
                return result;
            }
            case '/': {
                if (this.inTag) {
                    return this.parseEndTag((String)this.tags.pop());
                }
                return this.parseText();
            }
        }
        return this.parseText();
    }

    protected void fillBuffer() throws IOException {
        if (this.marked != null) {
            this.marked.append(this.buffer, 0, this.bufferPosition);
        } else if (this.mark != -1) {
            this.marked = new CharArrayBuffer(this.buffer, this.mark, this.bufferPosition - this.mark);
        }
        int read = this.reader.read(this.buffer);
        if (read > 0) {
            this.bufferLimit = read;
            this.bufferPosition = 0;
        }
    }

    protected char current() throws IOException {
        if (this.bufferPosition == this.bufferLimit) {
            this.fillBuffer();
        }
        if (this.bufferPosition == this.bufferLimit) {
            throw new EOFException();
        }
        return this.buffer[this.bufferPosition];
    }

    protected void step() {
        ++this.bufferPosition;
    }

    protected void mark() {
        this.mark = this.bufferPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String unmark() {
        block3: {
            try {
                if (this.marked == null) break block3;
                this.marked.append(this.buffer, 0, this.bufferPosition);
                String string = this.cache.get(this.marked.getBuffer(), 0, this.marked.getLength());
                Object var3_3 = null;
                this.mark = -1;
                this.marked = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.mark = -1;
                this.marked = null;
                throw throwable;
            }
        }
        String string = this.cache.get(this.buffer, this.mark, this.bufferPosition - this.mark);
        Object var3_4 = null;
        this.mark = -1;
        this.marked = null;
        return string;
    }

    protected void clearAttributes() {
        this.numAttributes = 0;
    }

    protected void addAttribute(String key, String value) {
        if (this.numAttributes == this.attributeKeys.length) {
            throw new RuntimeException("More than " + this.attributeKeys.length + " attributes encountered - unsupported!");
        }
        this.attributeKeys[this.numAttributes] = key;
        this.attributeValues[this.numAttributes] = value;
        ++this.numAttributes;
    }

    protected void expect(char c) throws XmlPullParserException, IOException {
        if (this.current() != c) {
            throw new XmlPullParserException("Expected character '" + c + "' got '" + this.current() + "'");
        }
        this.step();
    }

    protected boolean contains(char[] chars, char c) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return true;
        }
        return false;
    }

    protected String parseUntil(char[] chars) throws IOException {
        this.mark();
        while (!this.contains(chars, this.current())) {
            this.step();
        }
        return this.unmark();
    }

    protected String parseUntil(char c) throws IOException {
        this.mark();
        while (this.current() != c) {
            this.step();
        }
        return this.unmark();
    }

    protected void parseUntilNot(char[] chars) throws IOException {
        while (this.contains(chars, this.current())) {
            this.step();
        }
    }

    protected int parseEndTag(String tag) throws XmlPullParserException, IOException {
        this.expect('/');
        this.expect('>');
        this.name = tag;
        this.inTag = false;
        return 3;
    }

    protected int parseTag() throws XmlPullParserException, IOException {
        this.expect('<');
        switch (this.current()) {
            case '/': {
                return this.parseEndTag();
            }
            case '?': {
                return this.parseDocumentTag();
            }
        }
        return this.parseStartTag();
    }

    protected int parseEndTag() throws XmlPullParserException, IOException {
        this.expect('/');
        this.parseUntilNot(WHITESPACE);
        this.clearAttributes();
        this.name = this.parseUntil(WHITESPACE_OR_TAG_END);
        this.tags.pop();
        this.inTag = false;
        this.parseUntilNot(WHITESPACE);
        this.expect('>');
        return 3;
    }

    protected int parseStartTag() throws XmlPullParserException, IOException {
        this.parseUntilNot(WHITESPACE);
        this.name = this.parseUntil(WHITESPACE_OR_TAG_END);
        this.tags.push(this.name);
        this.parseUntilNot(WHITESPACE);
        this.parseAttributes();
        this.parseUntilNot(WHITESPACE);
        if (this.current() != '/') {
            this.expect('>');
            this.inTag = false;
        } else {
            this.inTag = true;
        }
        return 2;
    }

    protected int parseDocumentTag() throws XmlPullParserException, IOException {
        this.expect('?');
        this.parseUntilNot(WHITESPACE);
        String type = this.parseUntil(WHITESPACE_OR_TAG_END);
        if (!type.toLowerCase().equals("xml")) {
            throw new XmlPullParserException("This does not appear to be an XML document - found '" + type + "'!");
        }
        this.parseUntilNot(WHITESPACE);
        this.parseAttributes();
        this.clearAttributes();
        this.parseUntilNot(WHITESPACE);
        this.inTag = false;
        this.expect('?');
        this.expect('>');
        return 0;
    }

    protected void parseAttributes() throws XmlPullParserException, IOException {
        this.clearAttributes();
        while (true) {
            this.parseUntilNot(WHITESPACE);
            if (this.contains(TAG_END, this.current())) {
                return;
            }
            String key = this.parseUntil(WHITESPACE_OR_EQUALS);
            this.parseUntilNot(WHITESPACE);
            this.expect('=');
            this.parseUntilNot(WHITESPACE);
            String value = null;
            char quote = this.current();
            if (this.contains(QUOTE, quote)) {
                this.expect(quote);
                value = this.convert(this.parseUntil(quote));
                this.expect(quote);
            } else {
                value = this.convert(this.parseUntil(WHITESPACE_OR_TAG_END));
            }
            this.addAttribute(key, value);
        }
    }

    protected int parseText() throws XmlPullParserException, IOException {
        this.clearAttributes();
        this.text = this.convert(this.parseUntil('<'));
        this.inTag = false;
        return 4;
    }

    protected String convert(String string) {
        if (string.indexOf(38) < 0) {
            return string;
        }
        for (int i = 0; i < ENTITIES.length; ++i) {
            string = string.replaceAll(ENTITIES[i][0], ENTITIES[i][1]);
        }
        return string;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public int nextToken() throws XmlPullParserException, IOException {
        throw new UnsupportedOperationException();
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        throw new UnsupportedOperationException();
    }

    public String nextText() throws XmlPullParserException, IOException {
        throw new UnsupportedOperationException();
    }

    public int nextTag() throws XmlPullParserException, IOException {
        throw new UnsupportedOperationException();
    }

    public class CharArrayBuffer {
        protected char[] buffer = new char[32];
        protected int length = 0;
        public static final int DEFAULT_CAPACITY = 32;

        public CharArrayBuffer(char[] chars, int length, int off) {
            this.append(chars, length, off);
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getLength() {
            return this.length;
        }

        public void append(char[] chars, int off, int len) {
            while (this.length + len > this.buffer.length) {
                this.expandBuffer();
            }
            System.arraycopy(chars, off, this.buffer, this.length, len);
            this.length += len;
        }

        protected void expandBuffer() {
            char[] newbuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.length);
            this.buffer = newbuffer;
        }
    }
}

