/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe;

import java.io.IOException;
import java.io.Serializable;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class Topic
implements Serializable {
    protected Id id;

    public Topic(Id id) {
        this.id = id;
    }

    public Topic(IdFactory factory, String name) {
        this.id = Topic.getId(factory, name);
    }

    public Topic(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.id = endpoint.readId(buf, buf.readShort());
    }

    public Id getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof Topic) {
            return ((Topic)o).id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "[TOPIC " + this.id + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
    }

    public static Id getId(IdFactory factory, String name) {
        return factory.buildId(name);
    }
}

