/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.manager;

import java.util.HashMap;
import java.util.Iterator;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.replication.Replication;
import rice.p2p.replication.ReplicationClient;
import rice.p2p.replication.ReplicationImpl;
import rice.p2p.replication.ReplicationPolicy;
import rice.p2p.replication.manager.ReplicationManager;
import rice.p2p.replication.manager.ReplicationManagerClient;
import rice.p2p.replication.manager.ReplicationManagerImpl;
import rice.p2p.replication.manager.messaging.ReminderMessage;
import rice.p2p.replication.manager.messaging.TimeoutMessage;

public class ReplicationManagerImpl
implements ReplicationManager,
ReplicationClient,
Application {
    public final int FETCH_DELAY;
    public final int TIMEOUT_DELAY;
    public final int NUM_DELETE_AT_ONCE;
    protected IdFactory factory;
    protected Endpoint endpoint;
    protected ReplicationImpl replication;
    protected ReplicationManagerClient client;
    protected ReplicationManagerHelper helper;
    protected ReplicationManagerDeleter deleter;
    protected String instance;
    protected Environment environment;
    protected Logger logger;

    public ReplicationManagerImpl(Node node, ReplicationManagerClient client, int replicationFactor, String instance) {
        this(node, client, replicationFactor, instance, null);
    }

    public ReplicationManagerImpl(Node node, ReplicationManagerClient client, int replicationFactor, String instance, ReplicationPolicy policy) {
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(ReplicationManagerImpl.class, instance);
        Parameters p = this.environment.getParameters();
        this.FETCH_DELAY = p.getInt("p2p_replication_manager_fetch_delay");
        this.TIMEOUT_DELAY = p.getInt("p2p_replication_manager_timeout_delay");
        this.NUM_DELETE_AT_ONCE = p.getInt("p2p_replication_manager_num_delete_at_once");
        this.client = client;
        this.factory = node.getIdFactory();
        this.endpoint = node.buildEndpoint(this, instance);
        this.helper = new ReplicationManagerHelper();
        this.deleter = new ReplicationManagerDeleter();
        this.instance = instance;
        if (this.logger.level <= 500) {
            this.logger.log("Starting up ReplicationManagerImpl with client " + client);
        }
        this.replication = new ReplicationImpl(node, this, replicationFactor, instance, policy);
        this.endpoint.register();
    }

    public Replication getReplication() {
        return this.replication;
    }

    public void setRange(IdRange range) {
        if (this.logger.level <= 300) {
            this.logger.log("Removing range " + range + " from the list of pending ids");
        }
        this.helper.setRange(range);
        this.deleter.setRange(range);
    }

    protected IdSet clone(IdSet keySet) {
        IdSet result = this.factory.buildIdSet();
        Iterator i = keySet.getIterator();
        while (i.hasNext()) {
            result.addId((Id)i.next());
        }
        return result;
    }

    protected void informClient(final Id id, NodeHandle hint) {
        if (this.logger.level <= 500) {
            this.logger.log("Telling client to fetch id " + id);
        }
        final CancellableTask timer = this.endpoint.scheduleMessage(new TimeoutMessage(id), this.TIMEOUT_DELAY);
        this.client.fetch(id, hint, new Continuation(){

            public void receiveResult(Object o) {
                if (!new Boolean(true).equals(o)) {
                    if (o instanceof Throwable) {
                        if (ReplicationManagerImpl.this.logger.level <= 900) {
                            ReplicationManagerImpl.this.logger.logException("Fetching of id " + id + " failed with ", (Throwable)o);
                        }
                    } else if (ReplicationManagerImpl.this.logger.level <= 900) {
                        ReplicationManagerImpl.this.logger.log("Fetching of id " + id + " failed with " + o);
                    }
                }
                if (ReplicationManagerImpl.this.logger.level <= 500) {
                    ReplicationManagerImpl.this.logger.log("Successfully fetched id " + id);
                }
                timer.cancel();
                ReplicationManagerImpl.this.helper.message(id);
            }

            public void receiveException(Exception e) {
                this.receiveResult(e);
            }
        });
    }

    protected void scheduleNext() {
        if (this.logger.level <= 400) {
            this.logger.log("Scheduling next fetch in " + this.FETCH_DELAY + " milliseconds");
        }
        this.endpoint.scheduleMessage(new ReminderMessage(), this.FETCH_DELAY);
    }

    public void fetch(IdSet keySet, NodeHandle hint) {
        this.helper.fetch(keySet, hint);
    }

    public IdSet scan(IdRange range) {
        return this.client.scan(range);
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void deliver(Id id, Message message) {
        if (message instanceof ReminderMessage) {
            if (this.logger.level <= 300) {
                this.logger.log("Received reminder message");
            }
            this.helper.wakeup();
        } else if (message instanceof TimeoutMessage) {
            if (this.logger.level <= 300) {
                this.logger.log("Received timeout message");
            }
            this.helper.message(((TimeoutMessage)message).getId());
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unknown message " + message);
        }
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    protected class ReplicationManagerDeleter
    implements Continuation {
        protected IdSet set;
        protected Id id;

        public ReplicationManagerDeleter() {
            this.set = ReplicationManagerImpl.this.factory.buildIdSet();
        }

        public synchronized void setRange(IdRange range) {
            IdRange notRange = range.getComplementRange();
            Iterator i = ReplicationManagerImpl.this.client.scan(notRange).getIterator();
            for (int count = 0; i.hasNext() && count < ReplicationManagerImpl.this.NUM_DELETE_AT_ONCE; ++count) {
                Id next = (Id)i.next();
                if (this.id != null && this.id.equals(next)) continue;
                this.set.addId(next);
            }
            Iterator j = this.set.subSet(range).getIterator();
            while (j.hasNext()) {
                this.set.removeId((Id)j.next());
            }
            this.go();
        }

        protected synchronized void go() {
            if (this.id == null && this.set.numElements() > 0) {
                this.id = (Id)this.set.getIterator().next();
                this.set.removeId(this.id);
                if (ReplicationManagerImpl.this.logger.level <= 400) {
                    ReplicationManagerImpl.this.logger.log("Deciding whether to remove " + this.id);
                }
                ReplicationManagerImpl.this.client.existsInOverlay(this.id, new Continuation.StandardContinuation(this, this){
                    private final /* synthetic */ ReplicationManagerDeleter this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public void receiveResult(Object result) {
                        if (Boolean.TRUE.equals(result)) {
                            if (ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).logger.level <= 400) {
                                ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).logger.log("Telling client to delete id " + this.this$1.id);
                            }
                            if (ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).logger.level <= 400) {
                                ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).logger.log("RMImpl.go " + ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).instance + ": removing id " + this.this$1.id);
                            }
                            ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).client.remove(this.this$1.id, this.parent);
                        } else {
                            if (ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).logger.level <= 400) {
                                ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).logger.log("Object to remove " + this.this$1.id + " not found.  Reinserting.");
                            }
                            ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)this.this$1).client.reInsert(this.this$1.id, new Continuation.StandardContinuation(this, this.parent){
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                    super(x0);
                                }

                                public void receiveResult(Object result) {
                                    if (Boolean.TRUE.equals(result)) {
                                        if (ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).logger.level <= 400) {
                                            ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).logger.log("Telling client to delete id " + 2.access$100(this.this$2).id);
                                        }
                                        if (ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).logger.level <= 400) {
                                            ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).logger.log("RMImpl.go " + ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).instance + ": removing id " + 2.access$100(this.this$2).id);
                                        }
                                        ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).client.remove(2.access$100(this.this$2).id, this.parent);
                                    } else {
                                        if (ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).logger.level <= 400) {
                                            ReplicationManagerDeleter.access$000((ReplicationManagerDeleter)2.access$100(this.this$2)).logger.log("Object to remove " + 2.access$100(this.this$2).id + " Could not be reinserted.  Ignoring remove.");
                                        }
                                        this.receiveResult(Boolean.FALSE);
                                    }
                                }
                            });
                        }
                    }

                    static /* synthetic */ ReplicationManagerDeleter access$100(2 x0) {
                        return x0.this$1;
                    }
                });
            }
        }

        public synchronized void receiveResult(Object o) {
            if (this.id == null && ReplicationManagerImpl.this.logger.level <= 1000) {
                ReplicationManagerImpl.this.logger.log("ERROR: RMImpl.deleter Received result " + o + " unexpectedly!");
            }
            if (!Boolean.TRUE.equals(o) && ReplicationManagerImpl.this.logger.level <= 1000) {
                ReplicationManagerImpl.this.logger.log("ERROR: RMImpl.deleter Unstore of " + this.id + " did not succeed '" + o + "'!");
            }
            this.id = null;
            this.go();
        }

        public synchronized void receiveException(Exception e) {
            if (ReplicationManagerImpl.this.logger.level <= 1000) {
                ReplicationManagerImpl.this.logger.logException("RMImpl.deleter Unstore of " + this.id + " caused exception '" + e + "'!", e);
            }
            this.id = null;
            this.go();
        }

        static /* synthetic */ ReplicationManagerImpl access$000(ReplicationManagerDeleter x0) {
            return x0.ReplicationManagerImpl.this;
        }
    }

    protected class ReplicationManagerHelper {
        public int STATE_NOTHING = 0;
        public int STATE_WAITING = 1;
        public int STATE_SLEEPING = 2;
        protected int state;
        protected IdSet set;
        protected Id current;
        protected HashMap hints;

        public ReplicationManagerHelper() {
            this.set = ReplicationManagerImpl.this.factory.buildIdSet();
            this.hints = new HashMap();
            this.state = this.STATE_NOTHING;
        }

        protected synchronized Id getNextId() {
            if (this.set.numElements() == 0) {
                if (ReplicationManagerImpl.this.logger.level <= 900) {
                    ReplicationManagerImpl.this.logger.log("GetNextId called without any ids available - aborting");
                }
                return null;
            }
            this.current = (Id)this.set.getIterator().next();
            this.set.removeId(this.current);
            if (ReplicationManagerImpl.this.logger.level <= 400) {
                ReplicationManagerImpl.this.logger.log("Returing next id to fetch " + this.current);
            }
            if (!ReplicationManagerImpl.this.client.exists(this.current)) {
                return this.current;
            }
            return this.getNextId();
        }

        public synchronized void setRange(IdRange range) {
            IdRange notRange = range.getComplementRange();
            Iterator i = this.set.subSet(notRange).getIterator();
            while (i.hasNext()) {
                Id id = (Id)i.next();
                this.set.removeId(id);
                this.hints.remove(id);
            }
        }

        public synchronized void fetch(IdSet keySet, NodeHandle hint) {
            Iterator i = keySet.getIterator();
            while (i.hasNext()) {
                Id id = (Id)i.next();
                if (this.set.isMemberId(id) || ReplicationManagerImpl.this.client.exists(id) || this.current != null && id.equals(this.current)) continue;
                this.set.addId(id);
                this.hints.put(id, hint);
            }
            if (this.state == this.STATE_NOTHING && this.set.numElements() > 0) {
                this.send();
            }
        }

        public IdSet scan(IdRange range) {
            return this.set.subSet(range);
        }

        protected synchronized void send() {
            if (this.state != this.STATE_WAITING && this.set.numElements() > 0) {
                Id id = this.getNextId();
                NodeHandle hint = (NodeHandle)this.hints.remove(id);
                if (id != null) {
                    this.state = this.STATE_WAITING;
                    ReplicationManagerImpl.this.informClient(id, hint);
                } else {
                    this.state = this.STATE_NOTHING;
                }
            } else if (this.state != this.STATE_WAITING) {
                this.state = this.STATE_NOTHING;
            }
        }

        public synchronized void wakeup() {
            if (this.state == this.STATE_SLEEPING) {
                this.send();
            }
        }

        public synchronized void message(Id id) {
            if (this.state == this.STATE_WAITING && this.current != null && this.current.equals(id)) {
                this.state = this.STATE_SLEEPING;
                this.current = null;
                ReplicationManagerImpl.this.scheduleNext();
            }
        }
    }
}

