/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication;

import java.io.IOException;
import java.util.Iterator;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RangeCannotBeDeterminedException;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.replication.Replication;
import rice.p2p.replication.ReplicationClient;
import rice.p2p.replication.ReplicationPolicy;
import rice.p2p.replication.messaging.ReminderMessage;
import rice.p2p.replication.messaging.RequestMessage;
import rice.p2p.replication.messaging.ResponseMessage;
import rice.p2p.util.IdBloomFilter;

public class ReplicationImpl
implements Replication,
Application {
    public final int MAINTENANCE_INTERVAL;
    public final int MAX_KEYS_IN_MESSAGE;
    protected Endpoint endpoint;
    protected NodeHandle handle;
    protected IdFactory factory;
    protected ReplicationClient client;
    protected ReplicationPolicy policy;
    protected int replicationFactor;
    protected String instance;
    Environment environment;
    Logger logger;

    public ReplicationImpl(Node node, ReplicationClient client, int replicationFactor, String instance) {
        this(node, client, replicationFactor, instance, new ReplicationPolicy.DefaultReplicationPolicy());
    }

    public ReplicationImpl(Node node, ReplicationClient client, int replicationFactor, String instance, ReplicationPolicy policy) {
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(ReplicationImpl.class, instance);
        Parameters p = this.environment.getParameters();
        this.MAINTENANCE_INTERVAL = p.getInt("p2p_replication_maintenance_interval");
        this.MAX_KEYS_IN_MESSAGE = p.getInt("p2p_replication_max_keys_in_message");
        this.client = client;
        this.replicationFactor = replicationFactor;
        this.factory = node.getIdFactory();
        this.policy = policy;
        this.instance = instance;
        this.endpoint = node.buildEndpoint(this, instance);
        this.endpoint.setDeserializer(new MessageDeserializer(){

            public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
                switch (type) {
                    case 2: {
                        return RequestMessage.build(buf, ReplicationImpl.this.endpoint);
                    }
                    case 3: {
                        return ResponseMessage.build(buf, ReplicationImpl.this.endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown type:" + type);
            }
        });
        if (this.policy == null) {
            this.policy = new ReplicationPolicy.DefaultReplicationPolicy();
        }
        this.handle = this.endpoint.getLocalNodeHandle();
        if (this.logger.level <= 400) {
            this.logger.log("Starting up ReplicationImpl with client " + client + " and factor " + replicationFactor);
        }
        this.endpoint.register();
        this.endpoint.scheduleMessage(new ReminderMessage(this.handle), this.environment.getRandomSource().nextInt(this.MAINTENANCE_INTERVAL), this.MAINTENANCE_INTERVAL);
    }

    protected IdRange getTotalRange() {
        try {
            return this.endpoint.range(this.handle, this.replicationFactor, this.handle.getId(), true);
        }
        catch (RangeCannotBeDeterminedException rcbde) {
            if (this.logger.level <= 900) {
                this.logger.log("ReplicationImpl.getTotalRange():" + rcbde + " returning null.");
            }
            return null;
        }
    }

    private void updateClient() {
        if (this.logger.level <= 500) {
            this.logger.log("Updating client with range " + this.getTotalRange());
        }
        if (this.getTotalRange() != null) {
            this.client.setRange(this.getTotalRange());
        }
    }

    public void replicate() {
        final NodeHandleSet handles = this.endpoint.neighborSet(Integer.MAX_VALUE);
        final IdRange ourRange = this.endpoint.range(this.handle, 0, this.handle.getId());
        this.endpoint.process(new BloomFilterExecutable(ourRange), new Continuation.ListenerContinuation("Creation of our bloom filter", this.environment){
            int total;
            {
                super(x0, x1);
                this.total = 0;
            }

            public void receiveResult(Object o) {
                IdBloomFilter ourFilter = (IdBloomFilter)o;
                for (int i = 0; i < handles.size(); ++i) {
                    NodeHandle handle = handles.getHandle(i);
                    try {
                        IdRange handleRange = ReplicationImpl.this.endpoint.range(handle, 0, handle.getId());
                        IdRange range = handleRange.intersectRange(ReplicationImpl.this.getTotalRange());
                        if (range == null || range.intersectRange(ReplicationImpl.this.getTotalRange()).isEmpty()) continue;
                        ReplicationImpl.this.endpoint.process(new BloomFilterExecutable(range), new Continuation.StandardContinuation(this, this, handle, range, ourFilter){
                            private final /* synthetic */ NodeHandle val$handle;
                            private final /* synthetic */ IdRange val$range;
                            private final /* synthetic */ IdBloomFilter val$ourFilter;
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$handle = val$handle;
                                this.val$range = val$range;
                                this.val$ourFilter = val$ourFilter;
                                super(x0);
                            }

                            public void receiveResult(Object o) {
                                IdBloomFilter filter = (IdBloomFilter)o;
                                if (2.access$000(this.this$1).level <= 500) {
                                    2.access$300(this.this$1).log("COUNT: Sending request to " + this.val$handle + " for range " + this.val$range + ", " + 2.access$100(this.this$1) + " in instance " + 2.access$200(this.this$1).instance);
                                }
                                RequestMessage request = new RequestMessage(2.access$200(this.this$1).handle, new IdRange[]{this.val$range, 2.access$100(this.this$1)}, new IdBloomFilter[]{filter, this.val$ourFilter});
                                2.access$200(this.this$1).endpoint.route(null, request, this.val$handle);
                            }
                        });
                        continue;
                    }
                    catch (RangeCannotBeDeterminedException re) {
                        // empty catch block
                    }
                }
                if (this.logger.level <= 500) {
                    this.logger.log("COUNT: Done sending replications requests with " + this.total + " in instance " + ReplicationImpl.this.instance);
                }
            }

            static /* synthetic */ Logger access$000(2 x0) {
                return x0.logger;
            }

            static /* synthetic */ IdRange access$100(2 x0) {
                return x0.ourRange;
            }

            static /* synthetic */ ReplicationImpl access$200(2 x0) {
                return x0.ReplicationImpl.this;
            }

            static /* synthetic */ Logger access$300(2 x0) {
                return x0.logger;
            }
        });
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void deliver(Id id, Message message) {
        if (this.logger.level <= 500) {
            this.logger.log("COUNT: Replication " + this.instance + " received message " + message);
        }
        if (message instanceof RequestMessage) {
            final RequestMessage rm = (RequestMessage)message;
            Continuation.MultiContinuation continuation = new Continuation.MultiContinuation(new Continuation.ListenerContinuation("Processing of RequestMessage", this.environment){

                public void receiveResult(Object o) {
                    IdSet[] result;
                    block7: {
                        Object[] array = (Object[])o;
                        result = new IdSet[array.length];
                        if (array.length > 0 && array[0] instanceof Throwable) {
                            if (this.logger.level <= 1000) {
                                this.logger.logException("Errors in Multicontinuation:", (Throwable)array[0]);
                            }
                        } else {
                            try {
                                System.arraycopy(array, 0, result, 0, array.length);
                            }
                            catch (ArrayStoreException ase) {
                                if (array.length <= 0) break block7;
                                if (this.logger.level <= 1000) {
                                    this.logger.logException("Error copying " + array[0].getClass().getName() + ":" + array.length, ase);
                                }
                                throw ase;
                            }
                        }
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("COUNT: Telling node " + rm.getSource() + " to fetch");
                    }
                    ReplicationImpl.this.endpoint.route(null, new ResponseMessage(ReplicationImpl.this.handle, rm.getRanges(), result), rm.getSource());
                }
            }, rm.getRanges().length);
            for (int i = 0; i < rm.getRanges().length; ++i) {
                final int j = i;
                this.endpoint.process(new Executable(){

                    public String toString() {
                        return "process " + j + " of " + rm.getRanges().length + " namespace " + ReplicationImpl.this.instance;
                    }

                    public Object execute() {
                        IdSet set = ReplicationImpl.this.factory.buildIdSet();
                        rm.getFilters()[j].check(ReplicationImpl.this.client.scan(rm.getRanges()[j]), set, ReplicationImpl.this.MAX_KEYS_IN_MESSAGE);
                        return set;
                    }
                }, continuation.getSubContinuation(i));
            }
        } else if (message instanceof ResponseMessage) {
            ResponseMessage rm = (ResponseMessage)message;
            for (int i = 0; i < rm.getIdSets().length; ++i) {
                IdSet temp = this.factory.buildIdSet();
                Id[] tempA = rm.getIdSets()[i];
                for (int j = 0; j < tempA.length; ++j) {
                    temp.addId(tempA[j]);
                }
                IdSet fetch = this.policy.difference(this.client.scan(rm.getRanges()[i]), temp, this.factory);
                if (this.logger.level <= 500) {
                    this.logger.log("COUNT: Was told to fetch " + fetch.numElements() + " in instance " + this.instance);
                }
                if (fetch.numElements() <= 0) continue;
                this.client.fetch(fetch, rm.getSource());
            }
        } else if (message instanceof ReminderMessage) {
            this.replicate();
            this.updateClient();
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unknown message " + message + " - dropping on floor.");
        }
    }

    public void update(NodeHandle handle, boolean joined) {
        this.updateClient();
    }

    public static IdSet merge(IdFactory factory, IdSet a, IdSet b) {
        IdSet result = factory.buildIdSet();
        Iterator i = a.getIterator();
        while (i.hasNext()) {
            result.addId((Id)i.next());
        }
        i = b.getIterator();
        while (i.hasNext()) {
            result.addId((Id)i.next());
        }
        return result;
    }

    protected class BloomFilterExecutable
    implements Executable {
        protected IdRange range;

        public BloomFilterExecutable(IdRange range) {
            this.range = range;
        }

        public String toString() {
            return "bloomfilter range " + this.range + " namespace " + ReplicationImpl.this.instance;
        }

        public Object execute() {
            return new IdBloomFilter(ReplicationImpl.this.client.scan(this.range));
        }
    }
}

