/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.testing;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.PastImpl;
import rice.p2p.past.messaging.LookupMessage;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.past.rawserialization.RawPastContentHandle;
import rice.p2p.past.testing.RawPastRegrTest;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.PersistentStorage;
import rice.persistence.StorageManager;
import rice.persistence.StorageManagerImpl;

public class RawPastRegrTest
extends CommonAPITest {
    protected StorageManager[] storages;
    protected PastImpl[] pasts = new PastImpl[this.NUM_NODES];
    protected boolean running = true;
    public static String INSTANCE = "PastRegrTest";
    public static int REPLICATION_FACTOR = 3;

    public RawPastRegrTest(Environment env) throws IOException {
        super(env);
        this.storages = new StorageManager[this.NUM_NODES];
        if (this.PROTOCOL == "direct") {
            new Thread(){

                public void run() {
                    while (RawPastRegrTest.this.running) {
                        try {
                            1.sleep(50L);
                            RawPastRegrTest.this.simulate();
                        }
                        catch (Exception e) {
                            System.out.println(e + " blah");
                        }
                    }
                }
            }.start();
        }
    }

    protected void processNode(int num, Node node) {
        try {
            this.storages[num] = new StorageManagerImpl(this.FACTORY, new PersistentStorage(this.FACTORY, "root-" + num, ".", 1000000L, this.environment), new LRUCache(new MemoryStorage(this.FACTORY), 100000, this.environment));
            this.pasts[num] = new PastImpl(node, this.storages[num], REPLICATION_FACTOR, INSTANCE);
            this.pasts[num].setContentDeserializer(new PastContentDeserializer(){

                public PastContent deserializePastContent(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                    switch (contentType) {
                        case 1: {
                            return new TestPastContent(buf, endpoint, this);
                        }
                        case 2: {
                            return new VersionedTestPastContent(buf, endpoint, this);
                        }
                    }
                    throw new IllegalArgumentException("Unknown type:" + contentType);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pasts[num].setContentHandleDeserializer(new PastContentHandleDeserializer(){

            public PastContentHandle deserializePastContentHandle(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new TestPastContentHandle(buf, endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown type:" + contentType);
            }
        });
    }

    protected void runTest() {
        if (this.NUM_NODES < 2) {
            System.out.println("The DistPastRegrTest must be run with at least 2 nodes for proper testing.  Use the '-nodes n' to specify the number of nodes.");
            return;
        }
        this.testRouteRequest();
    }

    protected void testRouteRequest() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        final TestPastContent file = new TestPastContent(remoteId);
        this.sectionStart("Simple Route Request");
        this.stepStart("Initial Lookup");
        local.lookup(remoteId, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("File returned should be null", result == null);
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.stepStart("File Insertion");
                local.insert(file, new TestCommand(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.access$500(4.access$400(this.this$1), "Insert of file result should not be null", result != null);
                        RawPastRegrTest.access$600(4.access$400(this.this$1), "Insert of file should return Boolean[]", result instanceof Boolean[]);
                        for (int i = 0; i < ((Boolean[])result).length; ++i) {
                            RawPastRegrTest.access$700(4.access$400(this.this$1), "Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                            RawPastRegrTest.access$800(4.access$400(this.this$1), "Insert of file should succeed at replica", ((Boolean[])result)[i]);
                        }
                        RawPastRegrTest.access$900(4.access$400(this.this$1));
                        RawPastRegrTest.access$1000(4.access$400(this.this$1));
                        RawPastRegrTest.access$1100(4.access$400(this.this$1), "Remote File Lookup");
                        4.access$2600(this.this$1).lookup(4.access$1200(this.this$1), new TestCommand(this){
                            private final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.access$1400(4.access$400(5.access$1300(this.this$2)), "File should not be null", result != null);
                                RawPastRegrTest.access$1600(4.access$400(5.access$1300(this.this$2)), "Lookup of file should be correct", 4.access$1500(5.access$1300(this.this$2)), result);
                                RawPastRegrTest.access$1700(4.access$400(5.access$1300(this.this$2)));
                                RawPastRegrTest.access$1800(4.access$400(5.access$1300(this.this$2)), "Local File Lookup");
                                4.access$2400(5.access$1300(this.this$2)).getStorageManager().getObject(4.access$1200(5.access$1300(this.this$2)), new TestCommand(this){
                                    private final /* synthetic */ 6 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.access$2000(4.access$400(5.access$1300(6.access$1900(this.this$3))), "File should be inserted at known node", result != null);
                                        RawPastRegrTest.access$2100(4.access$400(5.access$1300(6.access$1900(this.this$3))), "Retrieved local file should be the same", 4.access$1500(5.access$1300(6.access$1900(this.this$3))), result);
                                        RawPastRegrTest.access$2200(4.access$400(5.access$1300(6.access$1900(this.this$3))));
                                        RawPastRegrTest.access$2300(4.access$400(5.access$1300(6.access$1900(this.this$3))));
                                        4.access$400(5.access$1300(6.access$1900(this.this$3))).testVersionControl();
                                    }
                                });
                                RawPastRegrTest.access$2500(4.access$400(5.access$1300(this.this$2)));
                            }

                            static /* synthetic */ 5 access$1900(6 x0) {
                                return x0.this$2;
                            }
                        });
                        RawPastRegrTest.access$2700(4.access$400(this.this$1));
                    }

                    static /* synthetic */ 4 access$1300(5 x0) {
                        return x0.this$1;
                    }
                });
                RawPastRegrTest.this.simulate();
            }

            static /* synthetic */ RawPastRegrTest access$400(4 x0) {
                return x0.RawPastRegrTest.this;
            }

            static /* synthetic */ Id access$1200(4 x0) {
                return x0.remoteId;
            }

            static /* synthetic */ PastContent access$1500(4 x0) {
                return x0.file;
            }

            static /* synthetic */ PastImpl access$2400(4 x0) {
                return x0.remote;
            }

            static /* synthetic */ PastImpl access$2600(4 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testVersionControl() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        final VersionedTestPastContent oldFile = new VersionedTestPastContent(remoteId, 0);
        final VersionedTestPastContent newFile = new VersionedTestPastContent(remoteId, 1);
        final NonOverwritingTestPastContent newNewFile = new NonOverwritingTestPastContent(remoteId, 2);
        this.sectionStart("Version Control");
        this.stepStart("File Insertion");
        local.insert(oldFile, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                    RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                    RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                }
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.runReplicaMaintence();
                RawPastRegrTest.this.stepStart("Remote File Lookup");
                local.lookup(remoteId, new TestCommand(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.access$3600(8.access$3500(this.this$1), "File should not be null", result != null);
                        RawPastRegrTest.access$3800(8.access$3500(this.this$1), "Lookup of file should be correct", 8.access$3700(this.this$1), result);
                        RawPastRegrTest.access$3900(8.access$3500(this.this$1));
                        RawPastRegrTest.access$4000(8.access$3500(this.this$1), "Overwriting File Insertion");
                        8.access$6800(this.this$1).insert(8.access$4100(this.this$1), new TestCommand(this){
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.access$4300(8.access$3500(9.access$4200(this.this$2)), "Insert of file result should not be null", result != null);
                                RawPastRegrTest.access$4400(8.access$3500(9.access$4200(this.this$2)), "Insert of file should return Boolean[]", result instanceof Boolean[]);
                                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                                    RawPastRegrTest.access$4500(8.access$3500(9.access$4200(this.this$2)), "Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                                    RawPastRegrTest.access$4600(8.access$3500(9.access$4200(this.this$2)), "Insert of file should succeed at replica", ((Boolean[])result)[i]);
                                }
                                RawPastRegrTest.access$4700(8.access$3500(9.access$4200(this.this$2)));
                                RawPastRegrTest.access$1000(8.access$3500(9.access$4200(this.this$2)));
                                RawPastRegrTest.access$4800(8.access$3500(9.access$4200(this.this$2)), "Remote Overwriting File Lookup");
                                8.access$6800(9.access$4200(this.this$2)).lookup(8.access$4900(9.access$4200(this.this$2)), new TestCommand(this){
                                    private final /* synthetic */ 10 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.access$5100(8.access$3500(9.access$4200(10.access$5000(this.this$3))), "Overwriting file should not be null", result != null);
                                        RawPastRegrTest.access$5200(8.access$3500(9.access$4200(10.access$5000(this.this$3))), "Lookup of overwriting file should be correct version", 8.access$4100(9.access$4200(10.access$5000(this.this$3))), result);
                                        RawPastRegrTest.access$5300(8.access$3500(9.access$4200(10.access$5000(this.this$3))));
                                        RawPastRegrTest.access$5400(8.access$3500(9.access$4200(10.access$5000(this.this$3))), "Non-overwriting File Insertion");
                                        8.access$6800(9.access$4200(10.access$5000(this.this$3))).insert(8.access$5500(9.access$4200(10.access$5000(this.this$3))), new TestCommand(this){
                                            private final /* synthetic */ 11 this$4;
                                            {
                                                this.this$4 = this$4;
                                            }

                                            public void receive(Object result) throws Exception {
                                                RawPastRegrTest.access$5700(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))), "Insert of file result should not be null", result != null);
                                                RawPastRegrTest.access$5800(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))), "Insert of file should return Boolean[]", result instanceof Boolean[]);
                                                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                                                    RawPastRegrTest.access$5900(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))), "Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                                                    RawPastRegrTest.access$6000(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))), "Insert of file should succeed at replica", ((Boolean[])result)[i]);
                                                }
                                                RawPastRegrTest.access$6100(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))));
                                                RawPastRegrTest.access$1000(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))));
                                                RawPastRegrTest.access$6200(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))), "Remote Non-Overwriting File Lookup");
                                                8.access$6800(9.access$4200(10.access$5000(11.access$5600(this.this$4)))).lookup(8.access$4900(9.access$4200(10.access$5000(11.access$5600(this.this$4)))), new TestCommand(this){
                                                    private final /* synthetic */ 12 this$5;
                                                    {
                                                        this.this$5 = this$5;
                                                    }

                                                    public void receive(Object result) throws Exception {
                                                        RawPastRegrTest.access$6400(8.access$3500(9.access$4200(10.access$5000(11.access$5600(12.access$6300(this.this$5))))), "Non-Overwriting file should not be null", result != null);
                                                        RawPastRegrTest.access$6500(8.access$3500(9.access$4200(10.access$5000(11.access$5600(12.access$6300(this.this$5))))), "Lookup of non-overwriting file should be correct (second) version", 8.access$4100(9.access$4200(10.access$5000(11.access$5600(12.access$6300(this.this$5))))), result);
                                                        RawPastRegrTest.access$6600(8.access$3500(9.access$4200(10.access$5000(11.access$5600(12.access$6300(this.this$5))))));
                                                        RawPastRegrTest.access$6700(8.access$3500(9.access$4200(10.access$5000(11.access$5600(12.access$6300(this.this$5))))));
                                                        8.access$3500(9.access$4200(10.access$5000(11.access$5600(12.access$6300(this.this$5))))).testFetch();
                                                    }
                                                });
                                                RawPastRegrTest.access$6900(8.access$3500(9.access$4200(10.access$5000(11.access$5600(this.this$4)))));
                                            }

                                            static /* synthetic */ 11 access$6300(12 x0) {
                                                return x0.this$4;
                                            }
                                        });
                                        RawPastRegrTest.access$7000(8.access$3500(9.access$4200(10.access$5000(this.this$3))));
                                    }

                                    static /* synthetic */ 10 access$5600(11 x0) {
                                        return x0.this$3;
                                    }
                                });
                                RawPastRegrTest.access$7100(8.access$3500(9.access$4200(this.this$2)));
                            }

                            static /* synthetic */ 9 access$5000(10 x0) {
                                return x0.this$2;
                            }
                        });
                        RawPastRegrTest.access$7200(8.access$3500(this.this$1));
                    }

                    static /* synthetic */ 8 access$4200(9 x0) {
                        return x0.this$1;
                    }
                });
                RawPastRegrTest.this.simulate();
            }

            static /* synthetic */ RawPastRegrTest access$3500(8 x0) {
                return x0.RawPastRegrTest.this;
            }

            static /* synthetic */ PastContent access$3700(8 x0) {
                return x0.oldFile;
            }

            static /* synthetic */ PastContent access$4100(8 x0) {
                return x0.newFile;
            }

            static /* synthetic */ Id access$4900(8 x0) {
                return x0.remoteId;
            }

            static /* synthetic */ PastContent access$5500(8 x0) {
                return x0.newNewFile;
            }

            static /* synthetic */ PastImpl access$6800(8 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testFetch() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final PastImpl remote1 = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl tmp = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        while (tmp == remote1) {
            tmp = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        }
        final PastImpl remote2 = tmp;
        final Id id = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)].getLocalNodeHandle().getId();
        final VersionedTestPastContent file1 = new VersionedTestPastContent(id, 1);
        final VersionedTestPastContent file2 = new VersionedTestPastContent(id, 2);
        final TestPastContentHandle handle1 = new TestPastContentHandle(remote1, id);
        final TestPastContentHandle handle2 = new TestPastContentHandle(remote2, id);
        this.sectionStart("Fetch Testing");
        this.stepStart("File 1 Insertion");
        remote1.getStorageManager().store(id, null, file1, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Storage of file 1 should succeed", (Boolean)result);
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.stepStart("File 2 Insertion");
                remote2.getStorageManager().store(id, null, file2, new TestCommand(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.access$7800(14.access$7700(this.this$1), "Storage of file 2 should succeed", (Boolean)result);
                        RawPastRegrTest.access$7900(14.access$7700(this.this$1));
                        RawPastRegrTest.access$8000(14.access$7700(this.this$1), "File 1 Fetch");
                        14.access$11300(this.this$1).fetch(14.access$8100(this.this$1), new TestCommand(this){
                            private final /* synthetic */ 15 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.access$8300(14.access$7700(15.access$8200(this.this$2)), "Result should be non-null", result != null);
                                RawPastRegrTest.access$8500(14.access$7700(15.access$8200(this.this$2)), "Result should be correct", 14.access$8400(15.access$8200(this.this$2)), result);
                                RawPastRegrTest.access$8700(14.access$7700(15.access$8200(this.this$2)), "Result should not be file 2", !14.access$8600(15.access$8200(this.this$2)).equals(result));
                                Object received1 = result;
                                RawPastRegrTest.access$8800(14.access$7700(15.access$8200(this.this$2)));
                                RawPastRegrTest.access$8900(14.access$7700(15.access$8200(this.this$2)), "File 2 Fetch");
                                14.access$11300(15.access$8200(this.this$2)).fetch(14.access$9000(15.access$8200(this.this$2)), new TestCommand(this, received1){
                                    private final /* synthetic */ Object val$received1;
                                    private final /* synthetic */ 16 this$3;
                                    {
                                        this.this$3 = this$3;
                                        this.val$received1 = val$received1;
                                    }

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.access$9200(14.access$7700(15.access$8200(16.access$9100(this.this$3))), "Result should be non-null", result != null);
                                        RawPastRegrTest.access$9300(14.access$7700(15.access$8200(16.access$9100(this.this$3))), "Result should be correct", 14.access$8600(15.access$8200(16.access$9100(this.this$3))), result);
                                        RawPastRegrTest.access$9400(14.access$7700(15.access$8200(16.access$9100(this.this$3))), "Result should not be file 1", !14.access$8400(15.access$8200(16.access$9100(this.this$3))).equals(result));
                                        Object received2 = result;
                                        RawPastRegrTest.access$9500(14.access$7700(15.access$8200(16.access$9100(this.this$3))));
                                        RawPastRegrTest.access$9600(14.access$7700(15.access$8200(16.access$9100(this.this$3))), "File 1 and 2 Different");
                                        RawPastRegrTest.access$9700(14.access$7700(15.access$8200(16.access$9100(this.this$3))), "Files should not be equal", !this.val$received1.equals(received2));
                                        RawPastRegrTest.access$9800(14.access$7700(15.access$8200(16.access$9100(this.this$3))));
                                        RawPastRegrTest.access$9900(14.access$7700(15.access$8200(16.access$9100(this.this$3))), "File 1 Removal");
                                        14.access$11100(15.access$8200(16.access$9100(this.this$3))).getStorageManager().unstore(14.access$10000(15.access$8200(16.access$9100(this.this$3))), new TestCommand(this){
                                            private final /* synthetic */ 17 this$4;
                                            {
                                                this.this$4 = this$4;
                                            }

                                            public void receive(Object result) throws Exception {
                                                RawPastRegrTest.access$10200(14.access$7700(15.access$8200(16.access$9100(17.access$10100(this.this$4)))), "Removal of file 1 should succeed", (Boolean)result);
                                                RawPastRegrTest.access$10300(14.access$7700(15.access$8200(16.access$9100(17.access$10100(this.this$4)))));
                                                RawPastRegrTest.access$10400(14.access$7700(15.access$8200(16.access$9100(17.access$10100(this.this$4)))), "File 2 Removal");
                                                14.access$10900(15.access$8200(16.access$9100(17.access$10100(this.this$4)))).getStorageManager().unstore(14.access$10000(15.access$8200(16.access$9100(17.access$10100(this.this$4)))), new TestCommand(this){
                                                    private final /* synthetic */ 18 this$5;
                                                    {
                                                        this.this$5 = this$5;
                                                    }

                                                    public void receive(Object result) throws Exception {
                                                        RawPastRegrTest.access$10600(14.access$7700(15.access$8200(16.access$9100(17.access$10100(18.access$10500(this.this$5))))), "Removal of file 2 should succeed", (Boolean)result);
                                                        RawPastRegrTest.access$10700(14.access$7700(15.access$8200(16.access$9100(17.access$10100(18.access$10500(this.this$5))))));
                                                        RawPastRegrTest.access$10800(14.access$7700(15.access$8200(16.access$9100(17.access$10100(18.access$10500(this.this$5))))));
                                                        14.access$7700(15.access$8200(16.access$9100(17.access$10100(18.access$10500(this.this$5))))).testLookupHandles();
                                                    }
                                                });
                                                RawPastRegrTest.access$11000(14.access$7700(15.access$8200(16.access$9100(17.access$10100(this.this$4)))));
                                            }

                                            static /* synthetic */ 17 access$10500(18 x0) {
                                                return x0.this$4;
                                            }
                                        });
                                        RawPastRegrTest.access$11200(14.access$7700(15.access$8200(16.access$9100(this.this$3))));
                                    }

                                    static /* synthetic */ 16 access$10100(17 x0) {
                                        return x0.this$3;
                                    }
                                });
                                RawPastRegrTest.access$11400(14.access$7700(15.access$8200(this.this$2)));
                            }

                            static /* synthetic */ 15 access$9100(16 x0) {
                                return x0.this$2;
                            }
                        });
                        RawPastRegrTest.access$11500(14.access$7700(this.this$1));
                    }

                    static /* synthetic */ 14 access$8200(15 x0) {
                        return x0.this$1;
                    }
                });
                RawPastRegrTest.this.simulate();
            }

            static /* synthetic */ RawPastRegrTest access$7700(14 x0) {
                return x0.RawPastRegrTest.this;
            }

            static /* synthetic */ PastContentHandle access$8100(14 x0) {
                return x0.handle1;
            }

            static /* synthetic */ PastContent access$8400(14 x0) {
                return x0.file1;
            }

            static /* synthetic */ PastContent access$8600(14 x0) {
                return x0.file2;
            }

            static /* synthetic */ PastContentHandle access$9000(14 x0) {
                return x0.handle2;
            }

            static /* synthetic */ Id access$10000(14 x0) {
                return x0.id;
            }

            static /* synthetic */ PastImpl access$10900(14 x0) {
                return x0.remote2;
            }

            static /* synthetic */ PastImpl access$11100(14 x0) {
                return x0.remote1;
            }

            static /* synthetic */ PastImpl access$11300(14 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testLookupHandles() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        TestPastContent file = new TestPastContent(remoteId);
        this.sectionStart("Lookup Handles Testing");
        this.stepStart("File Insertion");
        local.insert(file, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                RawPastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                System.out.println("PastRegrTest.testLookupHandles() insert result.length:" + ((Boolean[])result).length);
                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                    RawPastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                    RawPastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                }
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.runReplicaMaintence();
                RawPastRegrTest.this.stepStart("Remote Handles Lookup - 1 Replica");
                local.lookupHandles(remoteId, 1, new TestCommand(this){
                    private final /* synthetic */ 20 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.access$12400(20.access$12300(this.this$1), "Replicas should not be null", result != null);
                        RawPastRegrTest.access$12500(20.access$12300(this.this$1), "Replicas should be handle[]", result instanceof PastContentHandle[]);
                        RawPastRegrTest.access$12600(20.access$12300(this.this$1), "Only 1 replica should be returned", ((PastContentHandle[])result).length == 1);
                        if (((PastContentHandle[])result)[0] == null) {
                            System.out.println("PastRegrTest.problem");
                        }
                        RawPastRegrTest.access$12800(20.access$12300(this.this$1), "Replica should be for right object", 20.access$12700(this.this$1), ((PastContentHandle[])result)[0].getId());
                        RawPastRegrTest.access$12900(20.access$12300(this.this$1));
                        RawPastRegrTest.access$13000(20.access$12300(this.this$1), "Remote Handles Lookup - All Replicas");
                        20.access$14900(this.this$1).lookupHandles(20.access$12700(this.this$1), REPLICATION_FACTOR + 1, new TestCommand(this){
                            private final /* synthetic */ 21 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                int i;
                                RawPastRegrTest.access$13200(20.access$12300(21.access$13100(this.this$2)), "Replicas should not be null", result != null);
                                RawPastRegrTest.access$13300(20.access$12300(21.access$13100(this.this$2)), "Replicas should be handle[]", result instanceof PastContentHandle[]);
                                PastContentHandle[] handles = (PastContentHandle[])result;
                                RawPastRegrTest.access$13400(20.access$12300(21.access$13100(this.this$2)), "All replicas should be returned", handles.length == REPLICATION_FACTOR + 1 || 20.access$12300(21.access$13100(this.this$2)).NUM_NODES < REPLICATION_FACTOR + 1 && handles.length == 20.access$12300(21.access$13100(this.this$2)).NUM_NODES);
                                for (i = 0; i < handles.length; ++i) {
                                    RawPastRegrTest.access$13500(20.access$12300(21.access$13100(this.this$2)), "Replica " + i + " should not be null", handles[i] != null);
                                    RawPastRegrTest.access$13600(20.access$12300(21.access$13100(this.this$2)), "Replica " + i + " should be for right object", 20.access$12700(21.access$13100(this.this$2)), handles[i].getId());
                                }
                                for (i = 0; i < handles.length; ++i) {
                                    for (int j = 0; j < handles.length; ++j) {
                                        if (i == j) continue;
                                        RawPastRegrTest.access$13700(20.access$12300(21.access$13100(this.this$2)), "Handles " + handles[i] + " and " + handles[j] + " should be different", !handles[i].getNodeHandle().getId().equals(handles[j].getNodeHandle().getId()));
                                    }
                                }
                                RawPastRegrTest.access$13800(20.access$12300(21.access$13100(this.this$2)));
                                RawPastRegrTest.access$13900(20.access$12300(21.access$13100(this.this$2)), "Remote Handles Lookup - 12 Replicas");
                                20.access$14900(21.access$13100(this.this$2)).lookupHandles(20.access$12700(21.access$13100(this.this$2)), 12, new TestCommand(this){
                                    private final /* synthetic */ 22 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        int i;
                                        RawPastRegrTest.access$14100(20.access$12300(21.access$13100(22.access$14000(this.this$3))), "Replicas should not be null", result != null);
                                        RawPastRegrTest.access$14200(20.access$12300(21.access$13100(22.access$14000(this.this$3))), "Replicas should be handle[]", result instanceof PastContentHandle[]);
                                        PastContentHandle[] handles = (PastContentHandle[])result;
                                        RawPastRegrTest.access$14300(20.access$12300(21.access$13100(22.access$14000(this.this$3))), "All replicas should be returned, got " + handles.length, handles.length >= REPLICATION_FACTOR + 1 || 20.access$12300(21.access$13100(22.access$14000(this.this$3))).NUM_NODES < REPLICATION_FACTOR + 1 && handles.length == 20.access$12300(21.access$13100(22.access$14000(this.this$3))).NUM_NODES);
                                        int count = 0;
                                        for (i = 0; i < handles.length; ++i) {
                                            if (handles[i] == null) continue;
                                            RawPastRegrTest.access$14400(20.access$12300(21.access$13100(22.access$14000(this.this$3))), "Replica " + i + " should be for right object", 20.access$12700(21.access$13100(22.access$14000(this.this$3))), handles[i].getId());
                                            ++count;
                                        }
                                        RawPastRegrTest.access$14500(20.access$12300(21.access$13100(22.access$14000(this.this$3))), "All replicas should be returned (got " + count + "/" + (REPLICATION_FACTOR + 1) + ")", count == REPLICATION_FACTOR + 1);
                                        for (i = 0; i < handles.length; ++i) {
                                            for (int j = 0; j < handles.length; ++j) {
                                                if (i == j || handles[i] == null || handles[j] == null) continue;
                                                RawPastRegrTest.access$14600(20.access$12300(21.access$13100(22.access$14000(this.this$3))), "Handles " + handles[i] + " and " + handles[j] + " should be different", !handles[i].getNodeHandle().getId().equals(handles[j].getNodeHandle().getId()));
                                            }
                                        }
                                        RawPastRegrTest.access$14700(20.access$12300(21.access$13100(22.access$14000(this.this$3))));
                                        RawPastRegrTest.access$14800(20.access$12300(21.access$13100(22.access$14000(this.this$3))));
                                        20.access$12300(21.access$13100(22.access$14000(this.this$3))).testCaching();
                                    }
                                });
                                RawPastRegrTest.access$15000(20.access$12300(21.access$13100(this.this$2)));
                            }

                            static /* synthetic */ 21 access$14000(22 x0) {
                                return x0.this$2;
                            }
                        });
                        RawPastRegrTest.access$15100(20.access$12300(this.this$1));
                    }

                    static /* synthetic */ 20 access$13100(21 x0) {
                        return x0.this$1;
                    }
                });
                RawPastRegrTest.this.simulate();
            }

            static /* synthetic */ RawPastRegrTest access$12300(20 x0) {
                return x0.RawPastRegrTest.this;
            }

            static /* synthetic */ Id access$12700(20 x0) {
                return x0.remoteId;
            }

            static /* synthetic */ PastImpl access$14900(20 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testCaching() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id id1 = this.generateId();
        final Id id2 = this.generateId();
        final TestPastContent file1 = new TestPastContent(id1);
        final TestPastContent file2 = new TestPastContent(id2);
        final NonMutableTestPastContent file3 = new NonMutableTestPastContent(id2);
        this.sectionStart("Caching Testing");
        this.stepStart("Manually Inserting Object Into Cache");
        local.getStorageManager().getCache().cache(id1, null, file1, new TestCommand(){

            public void receive(Object result) throws Exception {
                RawPastRegrTest.this.assertTrue("Object should not be null", result != null);
                RawPastRegrTest.this.assertTrue("Object should be True", result.equals(new Boolean(true)));
                RawPastRegrTest.this.stepDone();
                RawPastRegrTest.this.stepStart("Local Lookup Satisfied by Cache");
                local.lookup(id1, new TestCommand(this){
                    private final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        RawPastRegrTest.access$15800(24.access$15700(this.this$1), "File should not be null", result != null);
                        RawPastRegrTest.access$16000(24.access$15700(this.this$1), "Lookup of file should be correct", 24.access$15900(this.this$1), result);
                        RawPastRegrTest.access$16100(24.access$15700(this.this$1));
                        RawPastRegrTest.access$16200(24.access$15700(this.this$1), "Caching Mutable Object");
                        LookupMessage lmsg = new LookupMessage(1, 24.access$16300(this.this$1), 24.access$16400(this.this$1).getLocalNodeHandle(), 24.access$16300(this.this$1));
                        lmsg.receiveResult(24.access$16500(this.this$1));
                        RawPastRegrTest.access$16600(24.access$15700(this.this$1), "Message should continue to be routed", 24.access$16400(this.this$1).forward(new TestRouteMessage(24.access$16300(this.this$1), null, lmsg)));
                        RawPastRegrTest.access$16700(24.access$15700(this.this$1));
                        RawPastRegrTest.access$16800(24.access$15700(this.this$1), "Cache Shouldn't Contain Object");
                        24.access$16400(this.this$1).getStorageManager().getObject(24.access$16300(this.this$1), new TestCommand(this, lmsg){
                            private final /* synthetic */ LookupMessage val$lmsg;
                            private final /* synthetic */ 25 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$lmsg = val$lmsg;
                            }

                            public void receive(Object result) throws Exception {
                                RawPastRegrTest.access$17000(24.access$15700(25.access$16900(this.this$2)), "Object should be null", result == null);
                                RawPastRegrTest.access$17100(24.access$15700(25.access$16900(this.this$2)));
                                RawPastRegrTest.access$17200(24.access$15700(25.access$16900(this.this$2)), "Caching Non-Mutable Object");
                                this.val$lmsg.receiveResult(24.access$17300(25.access$16900(this.this$2)));
                                RawPastRegrTest.access$17400(24.access$15700(25.access$16900(this.this$2)), "Message should continue to be routed", 24.access$16400(25.access$16900(this.this$2)).forward(new TestRouteMessage(24.access$16300(25.access$16900(this.this$2)), null, this.val$lmsg)));
                                RawPastRegrTest.access$17500(24.access$15700(25.access$16900(this.this$2)));
                                RawPastRegrTest.access$17600(24.access$15700(25.access$16900(this.this$2)), "Cache Should Contain Object");
                                24.access$16400(25.access$16900(this.this$2)).getStorageManager().getObject(24.access$16300(25.access$16900(this.this$2)), new TestCommand(this){
                                    private final /* synthetic */ 26 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        RawPastRegrTest.access$17800(24.access$15700(25.access$16900(26.access$17700(this.this$3))));
                                        LookupMessage lmsg = new LookupMessage(-1, 24.access$16300(25.access$16900(26.access$17700(this.this$3))), 24.access$16400(25.access$16900(26.access$17700(this.this$3))).getLocalNodeHandle(), 24.access$16300(25.access$16900(26.access$17700(this.this$3))));
                                        RawPastRegrTest.access$17900(24.access$15700(25.access$16900(26.access$17700(this.this$3))), "Lookup Satisfied By Cache");
                                        RawPastRegrTest.access$18000(24.access$15700(25.access$16900(26.access$17700(this.this$3))));
                                        RawPastRegrTest.access$18100(24.access$15700(25.access$16900(26.access$17700(this.this$3))));
                                        24.access$15700(25.access$16900(26.access$17700(this.this$3))).cleanUp();
                                    }
                                });
                                RawPastRegrTest.access$18200(24.access$15700(25.access$16900(this.this$2)));
                            }

                            static /* synthetic */ 25 access$17700(26 x0) {
                                return x0.this$2;
                            }
                        });
                        RawPastRegrTest.access$18300(24.access$15700(this.this$1));
                    }

                    static /* synthetic */ 24 access$16900(25 x0) {
                        return x0.this$1;
                    }
                });
                RawPastRegrTest.this.simulate();
            }

            static /* synthetic */ RawPastRegrTest access$15700(24 x0) {
                return x0.RawPastRegrTest.this;
            }

            static /* synthetic */ PastContent access$15900(24 x0) {
                return x0.file1;
            }

            static /* synthetic */ Id access$16300(24 x0) {
                return x0.id2;
            }

            static /* synthetic */ PastImpl access$16400(24 x0) {
                return x0.local;
            }

            static /* synthetic */ PastContent access$16500(24 x0) {
                return x0.file2;
            }

            static /* synthetic */ PastContent access$17300(24 x0) {
                return x0.file3;
            }
        });
        this.simulate();
    }

    private void runReplicaMaintence() {
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.pasts[i].getReplication().replicate();
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    protected void cleanUp() {
        this.running = false;
        this.environment.destroy();
    }

    public static void main(String[] args) throws Exception {
        LinkedList<File> delme = new LinkedList<File>();
        delme.add(new File("FreePastry-Storage-Root"));
        while (!delme.isEmpty()) {
            File f = (File)delme.removeFirst();
            if (f.isDirectory()) {
                File[] subs = f.listFiles();
                if (subs.length == 0) {
                    f.delete();
                    continue;
                }
                delme.addAll(Arrays.asList(subs));
                delme.addLast(f);
                continue;
            }
            f.delete();
        }
        Environment env = RawPastRegrTest.parseArgs(args);
        env.getParameters().setDouble("p2p_past_successfulInsertThreshold", 1.0);
        RawPastRegrTest pastTest = new RawPastRegrTest(env);
        pastTest.start();
    }

    static /* synthetic */ void access$500(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$700(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$800(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$900(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$1100(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$1400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$1600(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$1700(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$1800(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$2000(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$2100(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$2200(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$2300(RawPastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$2500(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$2700(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$3600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$3800(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$3900(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$4000(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$4300(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4500(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4700(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$4800(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$5100(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$5200(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$5300(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$5400(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$5700(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$5800(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$5900(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$6000(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$6100(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$6200(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$6400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$6500(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$6600(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$6700(RawPastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$6900(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7000(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7100(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7200(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7800(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$7900(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$8000(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$8300(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$8500(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$8700(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$8800(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$8900(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$9200(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$9300(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$9400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$9500(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$9600(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$9700(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$9800(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$9900(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$10200(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$10300(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$10400(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$10600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$10700(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$10800(RawPastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$11000(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$11200(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$11400(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$11500(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$12400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$12500(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$12600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$12800(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$12900(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$13000(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$13200(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13300(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13500(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13600(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$13700(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13800(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$13900(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$14100(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14200(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14300(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14400(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$14500(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14700(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$14800(RawPastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$15000(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$15100(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$15800(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$16000(RawPastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$16100(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$16200(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$16600(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$16700(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$16800(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$17000(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$17100(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$17200(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$17400(RawPastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$17500(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$17600(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$17800(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$17900(RawPastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$18000(RawPastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$18100(RawPastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$18200(RawPastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$18300(RawPastRegrTest x0) {
        x0.simulate();
    }

    protected static class TestRouteMessage
    implements RouteMessage {
        private Id id;
        private NodeHandle nextHop;
        private Message message;

        public TestRouteMessage(Id id, NodeHandle nextHop, Message message) {
            this.id = id;
            this.nextHop = nextHop;
            this.message = message;
        }

        public Id getDestinationId() {
            return this.id;
        }

        public NodeHandle getNextHopHandle() {
            return this.nextHop;
        }

        public Message getMessage() {
            return this.message;
        }

        public Message getMessage(MessageDeserializer md) {
            return this.message;
        }

        public void setDestinationId(Id id) {
            this.id = id;
        }

        public void setNextHopHandle(NodeHandle nextHop) {
            this.nextHop = nextHop;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public void setMessage(RawMessage message) {
            this.message = message;
        }
    }

    protected static class TestPastContentHandle
    implements RawPastContentHandle {
        protected NodeHandle handle;
        protected Id id;
        public static final short TYPE = 1;

        public TestPastContentHandle(Past past, Id id) {
            this.handle = past.getLocalNodeHandle();
            this.id = id;
        }

        public TestPastContentHandle(InputBuffer buf, Endpoint endpoint) throws IOException {
            this.handle = endpoint.readNodeHandle(buf);
            this.id = endpoint.readId(buf, buf.readShort());
        }

        public Id getId() {
            return this.id;
        }

        public NodeHandle getNodeHandle() {
            return this.handle;
        }

        public short getType() {
            return 1;
        }

        public void serialize(OutputBuffer buf) throws IOException {
            this.handle.serialize(buf);
            buf.writeShort(this.id.getType());
            this.id.serialize(buf);
        }
    }

    protected static class NonMutableTestPastContent
    extends TestPastContent {
        public NonMutableTestPastContent(Id id) {
            super(id);
        }

        public boolean isMutable() {
            return false;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NonMutableTestPastContent)) {
                return false;
            }
            return ((NonMutableTestPastContent)o).id.equals(this.id);
        }
    }

    protected static class NonOverwritingTestPastContent
    extends VersionedTestPastContent {
        public NonOverwritingTestPastContent(Id id, int version) {
            super(id, version);
        }

        public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
            return existingContent;
        }
    }

    protected static class VersionedTestPastContent
    extends TestPastContent {
        protected int version = 0;
        public static final short TYPE = 2;

        public VersionedTestPastContent(Id id, int version) {
            super(id);
            this.version = version;
        }

        public VersionedTestPastContent(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
            super(buf, endpoint, pcd);
            this.version = buf.readInt();
        }

        public short getType() {
            return 2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof VersionedTestPastContent)) {
                return false;
            }
            return ((VersionedTestPastContent)o).id.equals(this.id) && ((VersionedTestPastContent)o).version == this.version;
        }

        public String toString() {
            return "VersionedTestPastContent(" + this.id + ", " + this.version + ")";
        }

        public void serialize(OutputBuffer buf) throws IOException {
            super.serialize(buf);
            buf.writeInt(this.version);
        }
    }

    protected static class TestPastContent
    implements RawPastContent {
        protected Id id;
        protected RawPastContent existing;
        public static final short TYPE = 1;

        public TestPastContent(Id id) {
            this.id = id;
        }

        public TestPastContent(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
            this.id = endpoint.readId(buf, buf.readShort());
            if (buf.readBoolean()) {
                short contentType = buf.readShort();
                this.existing = (RawPastContent)pcd.deserializePastContent(buf, endpoint, contentType);
            }
        }

        public PastContentHandle getHandle(Past past) {
            return new TestPastContentHandle(past, this.id);
        }

        public Id getId() {
            return this.id;
        }

        public boolean isMutable() {
            return true;
        }

        public short getType() {
            return 1;
        }

        public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
            this.existing = (RawPastContent)existingContent;
            return this;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestPastContent)) {
                return false;
            }
            return ((TestPastContent)o).id.equals(this.id);
        }

        public String toString() {
            return "TestPastContent(" + this.id + ")";
        }

        public void serialize(OutputBuffer buf) throws IOException {
            buf.writeShort(this.id.getType());
            this.id.serialize(buf);
            if (this.existing == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeShort(this.existing.getType());
                this.existing.serialize(buf);
            }
        }
    }

    protected class TestExceptionCommand
    implements Continuation {
        protected TestExceptionCommand() {
        }

        public void receiveResult(Object result) {
            RawPastRegrTest.this.stepDone("FAILURE", "Command should throw an exception - got " + result);
        }

        public void receive(Object result) throws Exception {
        }

        public void receiveException(Exception e) {
            try {
                this.receive(e);
            }
            catch (Exception ex) {
                this.receiveException(ex);
            }
        }
    }

    protected class TestCommand
    implements Continuation {
        protected TestCommand() {
        }

        public void receiveResult(Object result) {
            try {
                this.receive(result);
            }
            catch (Exception e) {
                this.receiveException(e);
            }
        }

        public void receive(Object result) throws Exception {
        }

        public void receiveException(Exception e) {
            RawPastRegrTest.this.stepException(e);
        }
    }
}

