/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.testing;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.PastImpl;
import rice.p2p.past.messaging.LookupMessage;
import rice.p2p.past.testing.PastRegrTest;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.PersistentStorage;
import rice.persistence.StorageManager;
import rice.persistence.StorageManagerImpl;

public class PastRegrTest
extends CommonAPITest {
    protected StorageManager[] storages;
    protected PastImpl[] pasts = new PastImpl[this.NUM_NODES];
    protected boolean running = true;
    public static String INSTANCE = "PastRegrTest";
    public static int REPLICATION_FACTOR = 3;

    public PastRegrTest(Environment env) throws IOException {
        super(env);
        this.storages = new StorageManager[this.NUM_NODES];
        if (this.PROTOCOL == "direct") {
            new Thread(){

                public void run() {
                    while (PastRegrTest.this.running) {
                        try {
                            1.sleep(50L);
                            PastRegrTest.this.simulate();
                        }
                        catch (Exception e) {
                            System.out.println(e + " blah");
                        }
                    }
                }
            }.start();
        }
    }

    protected void processNode(int num, Node node) {
        try {
            this.storages[num] = new StorageManagerImpl(this.FACTORY, new PersistentStorage(this.FACTORY, "root-" + num, ".", 1000000L, this.environment), new LRUCache(new MemoryStorage(this.FACTORY), 100000, this.environment));
            this.pasts[num] = new PastImpl(node, this.storages[num], REPLICATION_FACTOR, INSTANCE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void runTest() {
        if (this.NUM_NODES < 2) {
            System.out.println("The DistPastRegrTest must be run with at least 2 nodes for proper testing.  Use the '-nodes n' to specify the number of nodes.");
            return;
        }
        this.testRouteRequest();
    }

    protected void testRouteRequest() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        final TestPastContent file = new TestPastContent(remoteId);
        this.sectionStart("Simple Route Request");
        this.stepStart("Initial Lookup");
        local.lookup(remoteId, new TestCommand(){

            public void receive(Object result) throws Exception {
                PastRegrTest.this.assertTrue("File returned should be null", result == null);
                PastRegrTest.this.stepDone();
                PastRegrTest.this.stepStart("File Insertion");
                local.insert(file, new TestCommand(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        PastRegrTest.access$500(2.access$400(this.this$1), "Insert of file result should not be null", result != null);
                        PastRegrTest.access$600(2.access$400(this.this$1), "Insert of file should return Boolean[]", result instanceof Boolean[]);
                        for (int i = 0; i < ((Boolean[])result).length; ++i) {
                            PastRegrTest.access$700(2.access$400(this.this$1), "Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                            PastRegrTest.access$800(2.access$400(this.this$1), "Insert of file should succeed at replica", ((Boolean[])result)[i]);
                        }
                        PastRegrTest.access$900(2.access$400(this.this$1));
                        PastRegrTest.access$1000(2.access$400(this.this$1));
                        PastRegrTest.access$1100(2.access$400(this.this$1), "Remote File Lookup");
                        2.access$2600(this.this$1).lookup(2.access$1200(this.this$1), new TestCommand(this){
                            private final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                PastRegrTest.access$1400(2.access$400(3.access$1300(this.this$2)), "File should not be null", result != null);
                                PastRegrTest.access$1600(2.access$400(3.access$1300(this.this$2)), "Lookup of file should be correct", 2.access$1500(3.access$1300(this.this$2)), result);
                                PastRegrTest.access$1700(2.access$400(3.access$1300(this.this$2)));
                                PastRegrTest.access$1800(2.access$400(3.access$1300(this.this$2)), "Local File Lookup");
                                2.access$2400(3.access$1300(this.this$2)).getStorageManager().getObject(2.access$1200(3.access$1300(this.this$2)), new TestCommand(this){
                                    private final /* synthetic */ 4 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        PastRegrTest.access$2000(2.access$400(3.access$1300(4.access$1900(this.this$3))), "File should be inserted at known node", result != null);
                                        PastRegrTest.access$2100(2.access$400(3.access$1300(4.access$1900(this.this$3))), "Retrieved local file should be the same", 2.access$1500(3.access$1300(4.access$1900(this.this$3))), result);
                                        PastRegrTest.access$2200(2.access$400(3.access$1300(4.access$1900(this.this$3))));
                                        PastRegrTest.access$2300(2.access$400(3.access$1300(4.access$1900(this.this$3))));
                                        2.access$400(3.access$1300(4.access$1900(this.this$3))).testVersionControl();
                                    }
                                });
                                PastRegrTest.access$2500(2.access$400(3.access$1300(this.this$2)));
                            }

                            static /* synthetic */ 3 access$1900(4 x0) {
                                return x0.this$2;
                            }
                        });
                        PastRegrTest.access$2700(2.access$400(this.this$1));
                    }

                    static /* synthetic */ 2 access$1300(3 x0) {
                        return x0.this$1;
                    }
                });
                PastRegrTest.this.simulate();
            }

            static /* synthetic */ PastRegrTest access$400(2 x0) {
                return x0.PastRegrTest.this;
            }

            static /* synthetic */ Id access$1200(2 x0) {
                return x0.remoteId;
            }

            static /* synthetic */ PastContent access$1500(2 x0) {
                return x0.file;
            }

            static /* synthetic */ PastImpl access$2400(2 x0) {
                return x0.remote;
            }

            static /* synthetic */ PastImpl access$2600(2 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testVersionControl() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        final VersionedTestPastContent oldFile = new VersionedTestPastContent(remoteId, 0);
        final VersionedTestPastContent newFile = new VersionedTestPastContent(remoteId, 1);
        final NonOverwritingTestPastContent newNewFile = new NonOverwritingTestPastContent(remoteId, 2);
        this.sectionStart("Version Control");
        this.stepStart("File Insertion");
        local.insert(oldFile, new TestCommand(){

            public void receive(Object result) throws Exception {
                PastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                PastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                    PastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                    PastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                }
                PastRegrTest.this.stepDone();
                PastRegrTest.this.runReplicaMaintence();
                PastRegrTest.this.stepStart("Remote File Lookup");
                local.lookup(remoteId, new TestCommand(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        PastRegrTest.access$3600(6.access$3500(this.this$1), "File should not be null", result != null);
                        PastRegrTest.access$3800(6.access$3500(this.this$1), "Lookup of file should be correct", 6.access$3700(this.this$1), result);
                        PastRegrTest.access$3900(6.access$3500(this.this$1));
                        PastRegrTest.access$4000(6.access$3500(this.this$1), "Overwriting File Insertion");
                        6.access$6800(this.this$1).insert(6.access$4100(this.this$1), new TestCommand(this){
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                PastRegrTest.access$4300(6.access$3500(7.access$4200(this.this$2)), "Insert of file result should not be null", result != null);
                                PastRegrTest.access$4400(6.access$3500(7.access$4200(this.this$2)), "Insert of file should return Boolean[]", result instanceof Boolean[]);
                                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                                    PastRegrTest.access$4500(6.access$3500(7.access$4200(this.this$2)), "Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                                    PastRegrTest.access$4600(6.access$3500(7.access$4200(this.this$2)), "Insert of file should succeed at replica", ((Boolean[])result)[i]);
                                }
                                PastRegrTest.access$4700(6.access$3500(7.access$4200(this.this$2)));
                                PastRegrTest.access$1000(6.access$3500(7.access$4200(this.this$2)));
                                PastRegrTest.access$4800(6.access$3500(7.access$4200(this.this$2)), "Remote Overwriting File Lookup");
                                6.access$6800(7.access$4200(this.this$2)).lookup(6.access$4900(7.access$4200(this.this$2)), new TestCommand(this){
                                    private final /* synthetic */ 8 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        PastRegrTest.access$5100(6.access$3500(7.access$4200(8.access$5000(this.this$3))), "Overwriting file should not be null", result != null);
                                        PastRegrTest.access$5200(6.access$3500(7.access$4200(8.access$5000(this.this$3))), "Lookup of overwriting file should be correct version", 6.access$4100(7.access$4200(8.access$5000(this.this$3))), result);
                                        PastRegrTest.access$5300(6.access$3500(7.access$4200(8.access$5000(this.this$3))));
                                        PastRegrTest.access$5400(6.access$3500(7.access$4200(8.access$5000(this.this$3))), "Non-overwriting File Insertion");
                                        6.access$6800(7.access$4200(8.access$5000(this.this$3))).insert(6.access$5500(7.access$4200(8.access$5000(this.this$3))), new TestCommand(this){
                                            private final /* synthetic */ 9 this$4;
                                            {
                                                this.this$4 = this$4;
                                            }

                                            public void receive(Object result) throws Exception {
                                                PastRegrTest.access$5700(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))), "Insert of file result should not be null", result != null);
                                                PastRegrTest.access$5800(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))), "Insert of file should return Boolean[]", result instanceof Boolean[]);
                                                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                                                    PastRegrTest.access$5900(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))), "Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                                                    PastRegrTest.access$6000(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))), "Insert of file should succeed at replica", ((Boolean[])result)[i]);
                                                }
                                                PastRegrTest.access$6100(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))));
                                                PastRegrTest.access$1000(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))));
                                                PastRegrTest.access$6200(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))), "Remote Non-Overwriting File Lookup");
                                                6.access$6800(7.access$4200(8.access$5000(9.access$5600(this.this$4)))).lookup(6.access$4900(7.access$4200(8.access$5000(9.access$5600(this.this$4)))), new TestCommand(this){
                                                    private final /* synthetic */ 10 this$5;
                                                    {
                                                        this.this$5 = this$5;
                                                    }

                                                    public void receive(Object result) throws Exception {
                                                        PastRegrTest.access$6400(6.access$3500(7.access$4200(8.access$5000(9.access$5600(10.access$6300(this.this$5))))), "Non-Overwriting file should not be null", result != null);
                                                        PastRegrTest.access$6500(6.access$3500(7.access$4200(8.access$5000(9.access$5600(10.access$6300(this.this$5))))), "Lookup of non-overwriting file should be correct (second) version", 6.access$4100(7.access$4200(8.access$5000(9.access$5600(10.access$6300(this.this$5))))), result);
                                                        PastRegrTest.access$6600(6.access$3500(7.access$4200(8.access$5000(9.access$5600(10.access$6300(this.this$5))))));
                                                        PastRegrTest.access$6700(6.access$3500(7.access$4200(8.access$5000(9.access$5600(10.access$6300(this.this$5))))));
                                                        6.access$3500(7.access$4200(8.access$5000(9.access$5600(10.access$6300(this.this$5))))).testFetch();
                                                    }
                                                });
                                                PastRegrTest.access$6900(6.access$3500(7.access$4200(8.access$5000(9.access$5600(this.this$4)))));
                                            }

                                            static /* synthetic */ 9 access$6300(10 x0) {
                                                return x0.this$4;
                                            }
                                        });
                                        PastRegrTest.access$7000(6.access$3500(7.access$4200(8.access$5000(this.this$3))));
                                    }

                                    static /* synthetic */ 8 access$5600(9 x0) {
                                        return x0.this$3;
                                    }
                                });
                                PastRegrTest.access$7100(6.access$3500(7.access$4200(this.this$2)));
                            }

                            static /* synthetic */ 7 access$5000(8 x0) {
                                return x0.this$2;
                            }
                        });
                        PastRegrTest.access$7200(6.access$3500(this.this$1));
                    }

                    static /* synthetic */ 6 access$4200(7 x0) {
                        return x0.this$1;
                    }
                });
                PastRegrTest.this.simulate();
            }

            static /* synthetic */ PastRegrTest access$3500(6 x0) {
                return x0.PastRegrTest.this;
            }

            static /* synthetic */ PastContent access$3700(6 x0) {
                return x0.oldFile;
            }

            static /* synthetic */ PastContent access$4100(6 x0) {
                return x0.newFile;
            }

            static /* synthetic */ Id access$4900(6 x0) {
                return x0.remoteId;
            }

            static /* synthetic */ PastContent access$5500(6 x0) {
                return x0.newNewFile;
            }

            static /* synthetic */ PastImpl access$6800(6 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testFetch() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final PastImpl remote1 = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl tmp = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        while (tmp == remote1) {
            tmp = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        }
        final PastImpl remote2 = tmp;
        final Id id = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)].getLocalNodeHandle().getId();
        final VersionedTestPastContent file1 = new VersionedTestPastContent(id, 1);
        final VersionedTestPastContent file2 = new VersionedTestPastContent(id, 2);
        final TestPastContentHandle handle1 = new TestPastContentHandle(remote1, id);
        final TestPastContentHandle handle2 = new TestPastContentHandle(remote2, id);
        this.sectionStart("Fetch Testing");
        this.stepStart("File 1 Insertion");
        remote1.getStorageManager().store(id, null, file1, new TestCommand(){

            public void receive(Object result) throws Exception {
                PastRegrTest.this.assertTrue("Storage of file 1 should succeed", (Boolean)result);
                PastRegrTest.this.stepDone();
                PastRegrTest.this.stepStart("File 2 Insertion");
                remote2.getStorageManager().store(id, null, file2, new TestCommand(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        PastRegrTest.access$7800(12.access$7700(this.this$1), "Storage of file 2 should succeed", (Boolean)result);
                        PastRegrTest.access$7900(12.access$7700(this.this$1));
                        PastRegrTest.access$8000(12.access$7700(this.this$1), "File 1 Fetch");
                        12.access$11300(this.this$1).fetch(12.access$8100(this.this$1), new TestCommand(this){
                            private final /* synthetic */ 13 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                PastRegrTest.access$8300(12.access$7700(13.access$8200(this.this$2)), "Result should be non-null", result != null);
                                PastRegrTest.access$8500(12.access$7700(13.access$8200(this.this$2)), "Result should be correct", 12.access$8400(13.access$8200(this.this$2)), result);
                                PastRegrTest.access$8700(12.access$7700(13.access$8200(this.this$2)), "Result should not be file 2", !12.access$8600(13.access$8200(this.this$2)).equals(result));
                                Object received1 = result;
                                PastRegrTest.access$8800(12.access$7700(13.access$8200(this.this$2)));
                                PastRegrTest.access$8900(12.access$7700(13.access$8200(this.this$2)), "File 2 Fetch");
                                12.access$11300(13.access$8200(this.this$2)).fetch(12.access$9000(13.access$8200(this.this$2)), new TestCommand(this, received1){
                                    private final /* synthetic */ Object val$received1;
                                    private final /* synthetic */ 14 this$3;
                                    {
                                        this.this$3 = this$3;
                                        this.val$received1 = val$received1;
                                    }

                                    public void receive(Object result) throws Exception {
                                        PastRegrTest.access$9200(12.access$7700(13.access$8200(14.access$9100(this.this$3))), "Result should be non-null", result != null);
                                        PastRegrTest.access$9300(12.access$7700(13.access$8200(14.access$9100(this.this$3))), "Result should be correct", 12.access$8600(13.access$8200(14.access$9100(this.this$3))), result);
                                        PastRegrTest.access$9400(12.access$7700(13.access$8200(14.access$9100(this.this$3))), "Result should not be file 1", !12.access$8400(13.access$8200(14.access$9100(this.this$3))).equals(result));
                                        Object received2 = result;
                                        PastRegrTest.access$9500(12.access$7700(13.access$8200(14.access$9100(this.this$3))));
                                        PastRegrTest.access$9600(12.access$7700(13.access$8200(14.access$9100(this.this$3))), "File 1 and 2 Different");
                                        PastRegrTest.access$9700(12.access$7700(13.access$8200(14.access$9100(this.this$3))), "Files should not be equal", !this.val$received1.equals(received2));
                                        PastRegrTest.access$9800(12.access$7700(13.access$8200(14.access$9100(this.this$3))));
                                        PastRegrTest.access$9900(12.access$7700(13.access$8200(14.access$9100(this.this$3))), "File 1 Removal");
                                        12.access$11100(13.access$8200(14.access$9100(this.this$3))).getStorageManager().unstore(12.access$10000(13.access$8200(14.access$9100(this.this$3))), new TestCommand(this){
                                            private final /* synthetic */ 15 this$4;
                                            {
                                                this.this$4 = this$4;
                                            }

                                            public void receive(Object result) throws Exception {
                                                PastRegrTest.access$10200(12.access$7700(13.access$8200(14.access$9100(15.access$10100(this.this$4)))), "Removal of file 1 should succeed", (Boolean)result);
                                                PastRegrTest.access$10300(12.access$7700(13.access$8200(14.access$9100(15.access$10100(this.this$4)))));
                                                PastRegrTest.access$10400(12.access$7700(13.access$8200(14.access$9100(15.access$10100(this.this$4)))), "File 2 Removal");
                                                12.access$10900(13.access$8200(14.access$9100(15.access$10100(this.this$4)))).getStorageManager().unstore(12.access$10000(13.access$8200(14.access$9100(15.access$10100(this.this$4)))), new TestCommand(this){
                                                    private final /* synthetic */ 16 this$5;
                                                    {
                                                        this.this$5 = this$5;
                                                    }

                                                    public void receive(Object result) throws Exception {
                                                        PastRegrTest.access$10600(12.access$7700(13.access$8200(14.access$9100(15.access$10100(16.access$10500(this.this$5))))), "Removal of file 2 should succeed", (Boolean)result);
                                                        PastRegrTest.access$10700(12.access$7700(13.access$8200(14.access$9100(15.access$10100(16.access$10500(this.this$5))))));
                                                        PastRegrTest.access$10800(12.access$7700(13.access$8200(14.access$9100(15.access$10100(16.access$10500(this.this$5))))));
                                                        12.access$7700(13.access$8200(14.access$9100(15.access$10100(16.access$10500(this.this$5))))).testLookupHandles();
                                                    }
                                                });
                                                PastRegrTest.access$11000(12.access$7700(13.access$8200(14.access$9100(15.access$10100(this.this$4)))));
                                            }

                                            static /* synthetic */ 15 access$10500(16 x0) {
                                                return x0.this$4;
                                            }
                                        });
                                        PastRegrTest.access$11200(12.access$7700(13.access$8200(14.access$9100(this.this$3))));
                                    }

                                    static /* synthetic */ 14 access$10100(15 x0) {
                                        return x0.this$3;
                                    }
                                });
                                PastRegrTest.access$11400(12.access$7700(13.access$8200(this.this$2)));
                            }

                            static /* synthetic */ 13 access$9100(14 x0) {
                                return x0.this$2;
                            }
                        });
                        PastRegrTest.access$11500(12.access$7700(this.this$1));
                    }

                    static /* synthetic */ 12 access$8200(13 x0) {
                        return x0.this$1;
                    }
                });
                PastRegrTest.this.simulate();
            }

            static /* synthetic */ PastRegrTest access$7700(12 x0) {
                return x0.PastRegrTest.this;
            }

            static /* synthetic */ PastContentHandle access$8100(12 x0) {
                return x0.handle1;
            }

            static /* synthetic */ PastContent access$8400(12 x0) {
                return x0.file1;
            }

            static /* synthetic */ PastContent access$8600(12 x0) {
                return x0.file2;
            }

            static /* synthetic */ PastContentHandle access$9000(12 x0) {
                return x0.handle2;
            }

            static /* synthetic */ Id access$10000(12 x0) {
                return x0.id;
            }

            static /* synthetic */ PastImpl access$10900(12 x0) {
                return x0.remote2;
            }

            static /* synthetic */ PastImpl access$11100(12 x0) {
                return x0.remote1;
            }

            static /* synthetic */ PastImpl access$11300(12 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testLookupHandles() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        PastImpl remote = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id remoteId = remote.getLocalNodeHandle().getId();
        TestPastContent file = new TestPastContent(remoteId);
        this.sectionStart("Lookup Handles Testing");
        this.stepStart("File Insertion");
        local.insert(file, new TestCommand(){

            public void receive(Object result) throws Exception {
                PastRegrTest.this.assertTrue("Insert of file result should not be null", result != null);
                PastRegrTest.this.assertTrue("Insert of file should return Boolean[]", result instanceof Boolean[]);
                for (int i = 0; i < ((Boolean[])result).length; ++i) {
                    PastRegrTest.this.assertTrue("Insert of file should not return null at replica", ((Boolean[])result)[i] != null);
                    PastRegrTest.this.assertTrue("Insert of file should succeed at replica", ((Boolean[])result)[i]);
                }
                PastRegrTest.this.stepDone();
                PastRegrTest.this.runReplicaMaintence();
                PastRegrTest.this.stepStart("Remote Handles Lookup - 1 Replica");
                local.lookupHandles(remoteId, 1, new TestCommand(this){
                    private final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        PastRegrTest.access$12400(18.access$12300(this.this$1), "Replicas should not be null", result != null);
                        PastRegrTest.access$12500(18.access$12300(this.this$1), "Replicas should be handle[]", result instanceof PastContentHandle[]);
                        PastRegrTest.access$12600(18.access$12300(this.this$1), "Only 1 replica should be returned", ((PastContentHandle[])result).length == 1);
                        if (((PastContentHandle[])result)[0] == null) {
                            System.out.println("PastRegrTest.problem");
                        }
                        PastRegrTest.access$12800(18.access$12300(this.this$1), "Replica should be for right object", 18.access$12700(this.this$1), ((PastContentHandle[])result)[0].getId());
                        PastRegrTest.access$12900(18.access$12300(this.this$1));
                        PastRegrTest.access$13000(18.access$12300(this.this$1), "Remote Handles Lookup - All Replicas");
                        18.access$14900(this.this$1).lookupHandles(18.access$12700(this.this$1), REPLICATION_FACTOR + 1, new TestCommand(this){
                            private final /* synthetic */ 19 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void receive(Object result) throws Exception {
                                int i;
                                PastRegrTest.access$13200(18.access$12300(19.access$13100(this.this$2)), "Replicas should not be null", result != null);
                                PastRegrTest.access$13300(18.access$12300(19.access$13100(this.this$2)), "Replicas should be handle[]", result instanceof PastContentHandle[]);
                                PastContentHandle[] handles = (PastContentHandle[])result;
                                PastRegrTest.access$13400(18.access$12300(19.access$13100(this.this$2)), "All replicas should be returned", handles.length == REPLICATION_FACTOR + 1 || 18.access$12300(19.access$13100(this.this$2)).NUM_NODES < REPLICATION_FACTOR + 1 && handles.length == 18.access$12300(19.access$13100(this.this$2)).NUM_NODES);
                                for (i = 0; i < handles.length; ++i) {
                                    PastRegrTest.access$13500(18.access$12300(19.access$13100(this.this$2)), "Replica " + i + " should not be null", handles[i] != null);
                                    PastRegrTest.access$13600(18.access$12300(19.access$13100(this.this$2)), "Replica " + i + " should be for right object", 18.access$12700(19.access$13100(this.this$2)), handles[i].getId());
                                }
                                for (i = 0; i < handles.length; ++i) {
                                    for (int j = 0; j < handles.length; ++j) {
                                        if (i == j) continue;
                                        PastRegrTest.access$13700(18.access$12300(19.access$13100(this.this$2)), "Handles " + handles[i] + " and " + handles[j] + " should be different", !handles[i].getNodeHandle().getId().equals(handles[j].getNodeHandle().getId()));
                                    }
                                }
                                PastRegrTest.access$13800(18.access$12300(19.access$13100(this.this$2)));
                                PastRegrTest.access$13900(18.access$12300(19.access$13100(this.this$2)), "Remote Handles Lookup - 12 Replicas");
                                18.access$14900(19.access$13100(this.this$2)).lookupHandles(18.access$12700(19.access$13100(this.this$2)), 12, new TestCommand(this){
                                    private final /* synthetic */ 20 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        int i;
                                        PastRegrTest.access$14100(18.access$12300(19.access$13100(20.access$14000(this.this$3))), "Replicas should not be null", result != null);
                                        PastRegrTest.access$14200(18.access$12300(19.access$13100(20.access$14000(this.this$3))), "Replicas should be handle[]", result instanceof PastContentHandle[]);
                                        PastContentHandle[] handles = (PastContentHandle[])result;
                                        PastRegrTest.access$14300(18.access$12300(19.access$13100(20.access$14000(this.this$3))), "All replicas should be returned, got " + handles.length, handles.length >= REPLICATION_FACTOR + 1 || 18.access$12300(19.access$13100(20.access$14000(this.this$3))).NUM_NODES < REPLICATION_FACTOR + 1 && handles.length == 18.access$12300(19.access$13100(20.access$14000(this.this$3))).NUM_NODES);
                                        int count = 0;
                                        for (i = 0; i < handles.length; ++i) {
                                            if (handles[i] == null) continue;
                                            PastRegrTest.access$14400(18.access$12300(19.access$13100(20.access$14000(this.this$3))), "Replica " + i + " should be for right object", 18.access$12700(19.access$13100(20.access$14000(this.this$3))), handles[i].getId());
                                            ++count;
                                        }
                                        PastRegrTest.access$14500(18.access$12300(19.access$13100(20.access$14000(this.this$3))), "All replicas should be returned (got " + count + "/" + (REPLICATION_FACTOR + 1) + ")", count == REPLICATION_FACTOR + 1);
                                        for (i = 0; i < handles.length; ++i) {
                                            for (int j = 0; j < handles.length; ++j) {
                                                if (i == j || handles[i] == null || handles[j] == null) continue;
                                                PastRegrTest.access$14600(18.access$12300(19.access$13100(20.access$14000(this.this$3))), "Handles " + handles[i] + " and " + handles[j] + " should be different", !handles[i].getNodeHandle().getId().equals(handles[j].getNodeHandle().getId()));
                                            }
                                        }
                                        PastRegrTest.access$14700(18.access$12300(19.access$13100(20.access$14000(this.this$3))));
                                        PastRegrTest.access$14800(18.access$12300(19.access$13100(20.access$14000(this.this$3))));
                                        18.access$12300(19.access$13100(20.access$14000(this.this$3))).testCaching();
                                    }
                                });
                                PastRegrTest.access$15000(18.access$12300(19.access$13100(this.this$2)));
                            }

                            static /* synthetic */ 19 access$14000(20 x0) {
                                return x0.this$2;
                            }
                        });
                        PastRegrTest.access$15100(18.access$12300(this.this$1));
                    }

                    static /* synthetic */ 18 access$13100(19 x0) {
                        return x0.this$1;
                    }
                });
                PastRegrTest.this.simulate();
            }

            static /* synthetic */ PastRegrTest access$12300(18 x0) {
                return x0.PastRegrTest.this;
            }

            static /* synthetic */ Id access$12700(18 x0) {
                return x0.remoteId;
            }

            static /* synthetic */ PastImpl access$14900(18 x0) {
                return x0.local;
            }
        });
        this.simulate();
    }

    protected void testCaching() {
        final PastImpl local = this.pasts[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        final Id id1 = this.generateId();
        final Id id2 = this.generateId();
        final TestPastContent file1 = new TestPastContent(id1);
        final TestPastContent file2 = new TestPastContent(id2);
        final NonMutableTestPastContent file3 = new NonMutableTestPastContent(id2);
        this.sectionStart("Caching Testing");
        this.stepStart("Manually Inserting Object Into Cache");
        local.getStorageManager().getCache().cache(id1, null, file1, new TestCommand(){

            public void receive(Object result) throws Exception {
                PastRegrTest.this.assertTrue("Object should not be null", result != null);
                PastRegrTest.this.assertTrue("Object should be True", result.equals(new Boolean(true)));
                PastRegrTest.this.stepDone();
                PastRegrTest.this.stepStart("Local Lookup Satisfied by Cache");
                local.lookup(id1, new TestCommand(this){
                    private final /* synthetic */ 22 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receive(Object result) throws Exception {
                        PastRegrTest.access$15800(22.access$15700(this.this$1), "File should not be null", result != null);
                        PastRegrTest.access$16000(22.access$15700(this.this$1), "Lookup of file should be correct", 22.access$15900(this.this$1), result);
                        PastRegrTest.access$16100(22.access$15700(this.this$1));
                        PastRegrTest.access$16200(22.access$15700(this.this$1), "Caching Mutable Object");
                        LookupMessage lmsg = new LookupMessage(1, 22.access$16300(this.this$1), 22.access$16400(this.this$1).getLocalNodeHandle(), 22.access$16300(this.this$1));
                        lmsg.receiveResult(22.access$16500(this.this$1));
                        PastRegrTest.access$16600(22.access$15700(this.this$1), "Message should continue to be routed", 22.access$16400(this.this$1).forward(new TestRouteMessage(22.access$16300(this.this$1), null, lmsg)));
                        PastRegrTest.access$16700(22.access$15700(this.this$1));
                        PastRegrTest.access$16800(22.access$15700(this.this$1), "Cache Shouldn't Contain Object");
                        22.access$16400(this.this$1).getStorageManager().getObject(22.access$16300(this.this$1), new TestCommand(this, lmsg){
                            private final /* synthetic */ LookupMessage val$lmsg;
                            private final /* synthetic */ 23 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$lmsg = val$lmsg;
                            }

                            public void receive(Object result) throws Exception {
                                PastRegrTest.access$17000(22.access$15700(23.access$16900(this.this$2)), "Object should be null", result == null);
                                PastRegrTest.access$17100(22.access$15700(23.access$16900(this.this$2)));
                                PastRegrTest.access$17200(22.access$15700(23.access$16900(this.this$2)), "Caching Non-Mutable Object");
                                this.val$lmsg.receiveResult(22.access$17300(23.access$16900(this.this$2)));
                                PastRegrTest.access$17400(22.access$15700(23.access$16900(this.this$2)), "Message should continue to be routed", 22.access$16400(23.access$16900(this.this$2)).forward(new TestRouteMessage(22.access$16300(23.access$16900(this.this$2)), null, this.val$lmsg)));
                                PastRegrTest.access$17500(22.access$15700(23.access$16900(this.this$2)));
                                PastRegrTest.access$17600(22.access$15700(23.access$16900(this.this$2)), "Cache Should Contain Object");
                                22.access$16400(23.access$16900(this.this$2)).getStorageManager().getObject(22.access$16300(23.access$16900(this.this$2)), new TestCommand(this){
                                    private final /* synthetic */ 24 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void receive(Object result) throws Exception {
                                        PastRegrTest.access$17800(22.access$15700(23.access$16900(24.access$17700(this.this$3))));
                                        LookupMessage lmsg = new LookupMessage(-1, 22.access$16300(23.access$16900(24.access$17700(this.this$3))), 22.access$16400(23.access$16900(24.access$17700(this.this$3))).getLocalNodeHandle(), 22.access$16300(23.access$16900(24.access$17700(this.this$3))));
                                        PastRegrTest.access$17900(22.access$15700(23.access$16900(24.access$17700(this.this$3))), "Lookup Satisfied By Cache");
                                        PastRegrTest.access$18000(22.access$15700(23.access$16900(24.access$17700(this.this$3))));
                                        PastRegrTest.access$18100(22.access$15700(23.access$16900(24.access$17700(this.this$3))));
                                        22.access$15700(23.access$16900(24.access$17700(this.this$3))).cleanUp();
                                    }
                                });
                                PastRegrTest.access$18200(22.access$15700(23.access$16900(this.this$2)));
                            }

                            static /* synthetic */ 23 access$17700(24 x0) {
                                return x0.this$2;
                            }
                        });
                        PastRegrTest.access$18300(22.access$15700(this.this$1));
                    }

                    static /* synthetic */ 22 access$16900(23 x0) {
                        return x0.this$1;
                    }
                });
                PastRegrTest.this.simulate();
            }

            static /* synthetic */ PastRegrTest access$15700(22 x0) {
                return x0.PastRegrTest.this;
            }

            static /* synthetic */ PastContent access$15900(22 x0) {
                return x0.file1;
            }

            static /* synthetic */ Id access$16300(22 x0) {
                return x0.id2;
            }

            static /* synthetic */ PastImpl access$16400(22 x0) {
                return x0.local;
            }

            static /* synthetic */ PastContent access$16500(22 x0) {
                return x0.file2;
            }

            static /* synthetic */ PastContent access$17300(22 x0) {
                return x0.file3;
            }
        });
        this.simulate();
    }

    private void runReplicaMaintence() {
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.pasts[i].getReplication().replicate();
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    protected void cleanUp() {
        this.running = false;
        this.environment.destroy();
    }

    public static void main(String[] args) throws Exception {
        LinkedList<File> delme = new LinkedList<File>();
        delme.add(new File("FreePastry-Storage-Root"));
        while (!delme.isEmpty()) {
            File f = (File)delme.removeFirst();
            if (f.isDirectory()) {
                File[] subs = f.listFiles();
                if (subs.length == 0) {
                    f.delete();
                    continue;
                }
                delme.addAll(Arrays.asList(subs));
                delme.addLast(f);
                continue;
            }
            f.delete();
        }
        Environment env = PastRegrTest.parseArgs(args);
        env.getParameters().setDouble("p2p_past_successfulInsertThreshold", 1.0);
        PastRegrTest pastTest = new PastRegrTest(env);
        pastTest.start();
    }

    static /* synthetic */ void access$500(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$700(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$800(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$900(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$1100(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$1400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$1600(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$1700(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$1800(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$2000(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$2100(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$2200(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$2300(PastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$2500(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$2700(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$3600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$3800(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$3900(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$4000(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$4300(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4500(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$4700(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$4800(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$5100(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$5200(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$5300(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$5400(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$5700(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$5800(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$5900(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$6000(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$6100(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$6200(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$6400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$6500(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$6600(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$6700(PastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$6900(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7000(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7100(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7200(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$7800(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$7900(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$8000(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$8300(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$8500(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$8700(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$8800(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$8900(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$9200(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$9300(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$9400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$9500(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$9600(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$9700(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$9800(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$9900(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$10200(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$10300(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$10400(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$10600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$10700(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$10800(PastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$11000(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$11200(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$11400(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$11500(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$12400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$12500(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$12600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$12800(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$12900(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$13000(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$13200(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13300(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13500(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13600(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$13700(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$13800(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$13900(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$14100(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14200(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14300(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14400(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$14500(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$14700(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$14800(PastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$15000(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$15100(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$15800(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$16000(PastRegrTest x0, String x1, Object x2, Object x3) {
        x0.assertEquals(x1, x2, x3);
    }

    static /* synthetic */ void access$16100(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$16200(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$16600(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$16700(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$16800(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$17000(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$17100(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$17200(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$17400(PastRegrTest x0, String x1, boolean x2) {
        x0.assertTrue(x1, x2);
    }

    static /* synthetic */ void access$17500(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$17600(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$17800(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$17900(PastRegrTest x0, String x1) {
        x0.stepStart(x1);
    }

    static /* synthetic */ void access$18000(PastRegrTest x0) {
        x0.stepDone();
    }

    static /* synthetic */ void access$18100(PastRegrTest x0) {
        x0.sectionDone();
    }

    static /* synthetic */ void access$18200(PastRegrTest x0) {
        x0.simulate();
    }

    static /* synthetic */ void access$18300(PastRegrTest x0) {
        x0.simulate();
    }

    protected static class TestRouteMessage
    implements RouteMessage {
        private Id id;
        private NodeHandle nextHop;
        private Message message;

        public TestRouteMessage(Id id, NodeHandle nextHop, Message message) {
            this.id = id;
            this.nextHop = nextHop;
            this.message = message;
        }

        public Id getDestinationId() {
            return this.id;
        }

        public NodeHandle getNextHopHandle() {
            return this.nextHop;
        }

        public Message getMessage() {
            return this.message;
        }

        public Message getMessage(MessageDeserializer md) {
            return this.message;
        }

        public void setDestinationId(Id id) {
            this.id = id;
        }

        public void setNextHopHandle(NodeHandle nextHop) {
            this.nextHop = nextHop;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public void setMessage(RawMessage message) {
            this.message = message;
        }
    }

    protected static class TestPastContentHandle
    implements PastContentHandle {
        protected NodeHandle handle;
        protected Id id;

        public TestPastContentHandle(Past past, Id id) {
            this.handle = past.getLocalNodeHandle();
            this.id = id;
        }

        public Id getId() {
            return this.id;
        }

        public NodeHandle getNodeHandle() {
            return this.handle;
        }
    }

    protected static class NonMutableTestPastContent
    extends TestPastContent {
        public NonMutableTestPastContent(Id id) {
            super(id);
        }

        public boolean isMutable() {
            return false;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NonMutableTestPastContent)) {
                return false;
            }
            return ((NonMutableTestPastContent)o).id.equals(this.id);
        }
    }

    protected static class NonOverwritingTestPastContent
    extends VersionedTestPastContent {
        public NonOverwritingTestPastContent(Id id, int version) {
            super(id, version);
        }

        public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
            return existingContent;
        }
    }

    protected static class VersionedTestPastContent
    extends TestPastContent {
        protected int version = 0;

        public VersionedTestPastContent(Id id, int version) {
            super(id);
            this.version = version;
        }

        public boolean equals(Object o) {
            if (!(o instanceof VersionedTestPastContent)) {
                return false;
            }
            return ((VersionedTestPastContent)o).id.equals(this.id) && ((VersionedTestPastContent)o).version == this.version;
        }

        public String toString() {
            return "VersionedTestPastContent(" + this.id + ", " + this.version + ")";
        }
    }

    protected static class TestPastContent
    implements PastContent {
        protected Id id;
        protected PastContent existing;

        public TestPastContent(Id id) {
            this.id = id;
        }

        public PastContentHandle getHandle(Past past) {
            return new TestPastContentHandle(past, this.id);
        }

        public Id getId() {
            return this.id;
        }

        public boolean isMutable() {
            return true;
        }

        public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
            this.existing = existingContent;
            return this;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestPastContent)) {
                return false;
            }
            return ((TestPastContent)o).id.equals(this.id);
        }

        public String toString() {
            return "TestPastContent(" + this.id + ")";
        }
    }

    protected class TestExceptionCommand
    implements Continuation {
        protected TestExceptionCommand() {
        }

        public void receiveResult(Object result) {
            PastRegrTest.this.stepDone("FAILURE", "Command should throw an exception - got " + result);
        }

        public void receive(Object result) throws Exception {
        }

        public void receiveException(Exception e) {
            try {
                this.receive(e);
            }
            catch (Exception ex) {
                this.receiveException(ex);
            }
        }
    }

    protected class TestCommand
    implements Continuation {
        protected TestCommand() {
        }

        public void receiveResult(Object result) {
            try {
                this.receive(result);
            }
            catch (Exception e) {
                this.receiveException(e);
            }
        }

        public void receive(Object result) throws Exception {
        }

        public void receiveException(Exception e) {
            PastRegrTest.this.stepException(e);
        }
    }
}

