/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.PastContent;
import rice.p2p.past.messaging.ContinuationMessage;
import rice.p2p.past.rawserialization.JavaSerializedPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;

public class InsertMessage
extends ContinuationMessage {
    protected RawPastContent content;
    public static final short TYPE = 4;
    static final long serialVersionUID = -7027957470028259605L;

    public InsertMessage(int uid, PastContent content, NodeHandle source, Id dest) {
        this(uid, content instanceof RawPastContent ? (RawPastContent)content : new JavaSerializedPastContent(content), source, dest);
    }

    public InsertMessage(int uid, RawPastContent content, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.content = content;
    }

    protected InsertMessage(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        super(buf, endpoint);
        if (this.serType == S_SUB) {
            this.response = new Boolean(buf.readBoolean());
        }
        if (buf.readBoolean()) {
            short contentType = buf.readShort();
            this.content = contentType == 0 ? new JavaSerializedPastContent(pcd.deserializePastContent(buf, endpoint, contentType)) : (RawPastContent)pcd.deserializePastContent(buf, endpoint, contentType);
        }
    }

    public PastContent getContent() {
        if (this.content.getType() == 0) {
            return ((JavaSerializedPastContent)this.content).getContent();
        }
        return this.content;
    }

    public short getType() {
        return 4;
    }

    public void receiveResult(Object o) {
        super.receiveResult(o);
        this.content = null;
    }

    public void receiveException(Exception e) {
        super.receiveException(e);
        this.content = null;
    }

    public String toString() {
        return "[InsertMessage for " + this.content + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.serializeHelper(buf);
    }

    protected void serializeHelper(OutputBuffer buf) throws IOException {
        if (this.response != null && this.response instanceof Boolean) {
            super.serialize(buf, false);
            buf.writeBoolean((Boolean)this.response);
        } else {
            super.serialize(buf, true);
        }
        buf.writeBoolean(this.content != null);
        if (this.content != null) {
            buf.writeShort(this.content.getType());
            this.content.serialize(buf);
        }
    }

    public static InsertMessage build(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new InsertMessage(buf, endpoint, pcd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

