/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.messaging.PastMessage;
import rice.p2p.util.JavaDeserializer;
import rice.p2p.util.rawserialization.JavaSerializationException;

public abstract class ContinuationMessage
extends PastMessage
implements Continuation {
    protected Object response;
    protected Exception exception;
    protected byte serType;
    static final long serialVersionUID = 1321112527034107161L;
    public static byte S_EMPTY = 0;
    public static byte S_SUB = 1;
    public static byte S_JAVA_RESPONSE = (byte)3;
    public static byte S_JAVA_EXCEPTION = (byte)2;

    protected ContinuationMessage(int uid, NodeHandle source, Id dest) {
        super(uid, source, dest);
    }

    public ContinuationMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.serType = buf.readByte();
        if (this.serType > S_SUB) {
            this.deserialize(buf, endpoint);
        }
    }

    public Object getResponse() {
        return this.response;
    }

    public void receiveResult(Object o) {
        this.setResponse();
        this.response = o;
    }

    public void receiveException(Exception e) {
        this.setResponse();
        this.exception = e;
    }

    public void returnResponse(Continuation c, Environment env, String instance) {
        if (this.exception == null) {
            c.receiveResult(this.response);
        } else {
            c.receiveException(this.exception);
        }
    }

    public void deserialize(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte[] array = new byte[buf.readInt()];
        buf.read(array);
        JavaDeserializer ois = new JavaDeserializer(new ByteArrayInputStream(array), endpoint);
        try {
            Object content = ois.readObject();
            if (this.serType == S_JAVA_RESPONSE) {
                this.response = content;
            } else {
                this.exception = (Exception)content;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown class type in message - closing channel.", e);
        }
    }

    public abstract void serialize(OutputBuffer var1) throws IOException;

    public void serialize(OutputBuffer buf, boolean javaSerialize) throws IOException {
        super.serialize(buf);
        this.serType = S_EMPTY;
        if (javaSerialize) {
            Object content = this.response;
            if (this.response != null) {
                this.serType = S_JAVA_RESPONSE;
            } else {
                this.serType = S_JAVA_EXCEPTION;
                content = this.exception;
            }
            if (content == null) {
                this.serType = S_EMPTY;
                buf.writeByte(this.serType);
            } else {
                try {
                    buf.writeByte(this.serType);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(content);
                    oos.close();
                    byte[] temp = baos.toByteArray();
                    buf.writeInt(temp.length);
                    buf.write(temp, 0, temp.length);
                }
                catch (IOException ioe) {
                    throw new JavaSerializationException(content, ioe);
                }
            }
        } else {
            buf.writeByte(S_SUB);
        }
    }
}

