/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdSet;
import rice.p2p.past.messaging.ContinuationMessage;

public class GCRefreshMessage
extends ContinuationMessage {
    protected GCId[] keys;
    public static final short TYPE = 11;

    public GCRefreshMessage(int uid, GCIdSet keys, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.keys = new GCId[keys.numElements()];
        System.arraycopy(keys.asArray(), 0, this.keys, 0, this.keys.length);
    }

    private GCRefreshMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        if (this.serType == S_SUB) {
            int arrayLength = buf.readInt();
            Boolean[] array = new Boolean[arrayLength];
            for (int i = 0; i < arrayLength; ++i) {
                array[i] = new Boolean(buf.readBoolean());
            }
        }
        this.keys = new GCId[buf.readInt()];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = (GCId)endpoint.readId(buf, buf.readShort());
        }
    }

    public GCId[] getKeys() {
        return this.keys;
    }

    public short getType() {
        return 11;
    }

    public String toString() {
        return "[GCRefreshMessage of " + this.keys.length + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        if (this.response != null && this.response instanceof Boolean[]) {
            super.serialize(buf, false);
            Boolean[] array = (Boolean[])this.response;
            buf.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                buf.writeBoolean(array[i]);
            }
        } else {
            super.serialize(buf, true);
        }
        buf.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            buf.writeShort(this.keys[i].getType());
            this.keys[i].serialize(buf);
        }
    }

    public static GCRefreshMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GCRefreshMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

