/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.PastContent;
import rice.p2p.past.messaging.InsertMessage;
import rice.p2p.past.rawserialization.PastContentDeserializer;

public class GCInsertMessage
extends InsertMessage {
    protected long expiration;
    public static final short TYPE = 9;

    public GCInsertMessage(int uid, PastContent content, long expiration, NodeHandle source, Id dest) {
        super(uid, content, source, dest);
        this.expiration = expiration;
    }

    private GCInsertMessage(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        super(buf, endpoint, pcd);
        this.expiration = buf.readLong();
    }

    public long getExpiration() {
        return this.expiration;
    }

    public short getType() {
        return 9;
    }

    public String toString() {
        return "[GCInsertMessage for " + this.content + " exp " + this.expiration + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serializeHelper(buf);
        buf.writeLong(this.expiration);
    }

    public static GCInsertMessage buildGC(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GCInsertMessage(buf, endpoint, pcd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

