/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.MathUtils;

public class GCId
implements Id {
    protected Id id;
    protected long expiration;
    public static final short TYPE = 3;

    public GCId(Id id, long expiration) {
        this.id = id;
        this.expiration = expiration;
    }

    public GCId(InputBuffer buf, Endpoint endpoint) throws IOException {
        buf.readShort();
        this.expiration = buf.readLong();
        this.id = endpoint.readId(buf, buf.readShort());
    }

    public Id getId() {
        return this.id;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean isBetween(Id ccw, Id cw) {
        return this.id.isBetween(((GCId)ccw).getId(), ((GCId)cw).getId());
    }

    public int getByteArrayLength() {
        return this.id.getByteArrayLength() + 8;
    }

    public short getType() {
        return 3;
    }

    public boolean clockwise(Id nid) {
        return this.id.clockwise(((GCId)nid).getId());
    }

    public Id addToId(Id.Distance offset) {
        return new GCId(this.id.addToId(offset), this.expiration);
    }

    public Id.Distance distanceFromId(Id nid) {
        return this.id.distanceFromId(((GCId)nid).getId());
    }

    public Id.Distance longDistanceFromId(Id nid) {
        return this.id.longDistanceFromId(((GCId)nid).getId());
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.getByteArrayLength()];
        this.toByteArray(result, 0);
        return result;
    }

    public void toByteArray(byte[] array, int offset) {
        this.id.toByteArray(array, offset);
        MathUtils.longToByteArray(this.expiration, array, offset + this.id.getByteArrayLength());
    }

    public boolean equals(Object o) {
        if (!(o instanceof GCId)) {
            return false;
        }
        return ((GCId)o).id.equals(this.id) && ((GCId)o).expiration == this.expiration;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id + "-" + this.expiration;
    }

    public String toStringFull() {
        return this.id.toStringFull() + "-" + this.expiration;
    }

    public int compareTo(Object o) {
        return this.id.compareTo(((GCId)o).id);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.getType());
        buf.writeLong(this.expiration);
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
    }
}

