/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc;

import java.io.IOException;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdRange;

public class GCEndpoint
implements Endpoint {
    protected Endpoint endpoint;

    protected GCEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Id getId() {
        return this.endpoint.getId();
    }

    public NodeHandle getLocalNodeHandle() {
        return this.endpoint.getLocalNodeHandle();
    }

    public String getInstance() {
        return "GC" + this.endpoint.getInstance();
    }

    public Environment getEnvironment() {
        return this.endpoint.getEnvironment();
    }

    public MessageDeserializer getDeserializer() {
        return this.endpoint.getDeserializer();
    }

    public void setDeserializer(MessageDeserializer md) {
        this.endpoint.setDeserializer(md);
    }

    public void route(Id id, Message message, NodeHandle hint) {
        this.endpoint.route(id, message, hint);
    }

    public void route(Id id, RawMessage message, NodeHandle hint) {
        this.endpoint.route(id, message, hint);
    }

    public NodeHandleSet localLookup(Id id, int num, boolean safe) {
        return this.endpoint.localLookup(id, num, safe);
    }

    public NodeHandleSet neighborSet(int num) {
        return this.endpoint.neighborSet(num);
    }

    public NodeHandleSet replicaSet(Id id, int maxRank) {
        return this.endpoint.replicaSet(id, maxRank);
    }

    public NodeHandleSet replicaSet(Id id, int maxRank, NodeHandle root, NodeHandleSet set) {
        return this.endpoint.replicaSet(id, maxRank, root, set);
    }

    public IdRange range(NodeHandle handle, int rank, Id lkey) {
        IdRange range = this.endpoint.range(handle, rank, lkey);
        return range == null ? null : new GCIdRange(range);
    }

    public IdRange range(NodeHandle handle, int rank, Id lkey, boolean cumulative) {
        IdRange range = this.endpoint.range(handle, rank, lkey, cumulative);
        return range == null ? null : new GCIdRange(range);
    }

    public CancellableTask scheduleMessage(Message message, long delay) {
        return this.endpoint.scheduleMessage(message, delay);
    }

    public CancellableTask scheduleMessage(Message message, long delay, long period) {
        return this.endpoint.scheduleMessage(message, delay, period);
    }

    public CancellableTask scheduleMessageAtFixedRate(Message message, long delay, long period) {
        return this.endpoint.scheduleMessageAtFixedRate(message, delay, period);
    }

    public void process(Executable task, Continuation command) {
        this.endpoint.process(task, command);
    }

    public void connect(NodeHandle handle, AppSocketReceiver receiver, int timeout) {
        this.endpoint.connect(handle, receiver, timeout);
    }

    public void accept(AppSocketReceiver receiver) {
        this.endpoint.accept(receiver);
    }

    public Id readId(InputBuffer buf, short type) throws IOException {
        if (type == 3) {
            return new GCId(buf, this.endpoint);
        }
        return this.endpoint.readId(buf, type);
    }

    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.endpoint.readNodeHandle(buf);
    }

    public IdRange readIdRange(InputBuffer buf) throws IOException {
        return new GCIdRange(buf, this.endpoint);
    }

    public NodeHandle coalesce(NodeHandle handle) {
        return this.endpoint.coalesce(handle);
    }

    public NodeHandleSet readNodeHandleSet(InputBuffer buf, short type) throws IOException {
        return this.endpoint.readNodeHandleSet(buf, type);
    }

    public String toString() {
        return "GCE[" + this.endpoint + "]";
    }

    public void register() {
        this.endpoint.register();
    }
}

