/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring.messaging;

import java.io.IOException;
import java.util.Hashtable;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.multiring.RingId;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.util.JavaSerializedMessage;

public class RingMessage
implements ScribeContent {
    protected RingId id;
    protected RawMessage message;
    protected String application;
    private static final long serialVersionUID = -7097995807488121199L;
    public static final short TYPE = 1;

    public RingMessage(RingId id, RawMessage message, String application) {
        this.id = id;
        this.message = message;
        this.application = application;
    }

    public RingMessage(InputBuffer buf, Endpoint ringEndpoint, Hashtable endpoints) throws IOException {
        this.id = new RingId(buf, ringEndpoint);
        this.application = buf.readUTF();
        Endpoint endpoint = (Endpoint)endpoints.get(this.application);
        if (endpoint == null) {
            throw new IOException("Couldn't find application:" + this.application);
        }
        MessageDeserializer md = endpoint.getDeserializer();
        short type = buf.readShort();
        byte priority = buf.readByte();
        Message m = md.deserialize(buf, type, priority, null);
        this.message = type == 0 ? new JavaSerializedMessage(m) : (RawMessage)m;
    }

    public byte getPriority() {
        return this.message.getPriority();
    }

    public RingId getId() {
        return this.id;
    }

    public RawMessage getMessage() {
        return this.message;
    }

    public String getApplication() {
        return this.application;
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.id.serialize(buf);
        buf.writeUTF(this.application);
        buf.writeShort(this.message.getType());
        buf.writeByte(this.message.getPriority());
        this.message.serialize(buf);
    }
}

