/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.multiring.RingId;

public class MultiringIdRange
implements IdRange {
    protected IdRange range;
    protected Id ringId;

    protected MultiringIdRange(Id ringId, IdRange range) {
        this.ringId = ringId;
        this.range = range;
        if (ringId instanceof RingId || range instanceof MultiringIdRange) {
            throw new IllegalArgumentException("Illegal creation of MRIdRange: " + ringId.getClass() + ", " + range.getClass());
        }
    }

    public MultiringIdRange(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.ringId = endpoint.readId(buf, buf.readShort());
        this.range = endpoint.readIdRange(buf);
    }

    protected IdRange getRange() {
        return this.range;
    }

    public Id getCCWId() {
        return RingId.build(this.ringId, this.range.getCCWId());
    }

    public Id getCWId() {
        return RingId.build(this.ringId, this.range.getCWId());
    }

    public IdRange getComplementRange() {
        return new MultiringIdRange(this.ringId, this.range.getComplementRange());
    }

    public boolean isEmpty() {
        return this.range.isEmpty();
    }

    public boolean containsId(Id key) {
        if (key instanceof RingId) {
            RingId rkey = (RingId)key;
            if (!rkey.getRingId().equals(this.ringId)) {
                return false;
            }
            return this.range.containsId(rkey.getId());
        }
        throw new IllegalArgumentException("Cannot test membership for keys other than RingId");
    }

    public IdRange mergeRange(IdRange merge) {
        return new MultiringIdRange(this.ringId, this.range.mergeRange(((MultiringIdRange)merge).getRange()));
    }

    public IdRange diffRange(IdRange diff) {
        return new MultiringIdRange(this.ringId, this.range.diffRange(((MultiringIdRange)diff).getRange()));
    }

    public IdRange intersectRange(IdRange intersect) {
        return new MultiringIdRange(this.ringId, this.range.intersectRange(((MultiringIdRange)intersect).getRange()));
    }

    public boolean equals(Object o) {
        MultiringIdRange other = (MultiringIdRange)o;
        return other.getRange().equals(this.range) && other.ringId.equals(this.ringId);
    }

    public int hashCode() {
        return this.range.hashCode() + this.ringId.hashCode();
    }

    public String toString() {
        return "{RingId " + this.ringId + " " + this.range.toString() + "}";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.ringId.getType());
        this.ringId.serialize(buf);
        this.range.serialize(buf);
    }
}

