/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.BloomFilter;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierSyncMessage
extends GlacierMessage {
    protected IdRange range;
    protected int offsetFID;
    protected BloomFilter BloomFilter;
    public static final short TYPE = 14;

    public GlacierSyncMessage(int uid, IdRange range, int offsetFID, BloomFilter BloomFilter2, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.range = range;
        this.offsetFID = offsetFID;
        this.BloomFilter = BloomFilter2;
    }

    private GlacierSyncMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.offsetFID = buf.readInt();
        this.range = endpoint.readIdRange(buf);
        this.BloomFilter = new BloomFilter(buf);
    }

    public int getOffsetFID() {
        return this.offsetFID;
    }

    public IdRange getRange() {
        return this.range;
    }

    public BloomFilter getBloomFilter() {
        return this.BloomFilter;
    }

    public short getType() {
        return 14;
    }

    public String toString() {
        return "[GlacierSync for range " + this.range + ", offset " + this.offsetFID + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.offsetFID);
        this.range.serialize(buf);
        this.BloomFilter.serialize(buf);
    }

    public static GlacierSyncMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierSyncMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

