/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRefreshProbeMessage
extends GlacierMessage {
    protected Id requestedId;
    public static final short TYPE = 11;

    public GlacierRefreshProbeMessage(int uid, Id requestedId, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.requestedId = requestedId;
    }

    private GlacierRefreshProbeMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.requestedId = endpoint.readId(buf, buf.readShort());
    }

    public Id getRequestedId() {
        return this.requestedId;
    }

    public short getType() {
        return 11;
    }

    public String toString() {
        return "[GlacierRefreshProbe #" + this.getUID() + " for " + this.requestedId + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeShort(this.requestedId.getType());
        this.requestedId.serialize(buf);
    }

    public static GlacierRefreshProbeMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRefreshProbeMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

